<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Department Management
      <small>Add / Edit Sub Department</small>
    </h1>
  </section>
  <section class="content">
    <div class="row">
      <!-- left column -->
      <div class="col-md-6">
        <!-- general form elements -->
        <?php
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>
        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Sub Department Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <?php if (isset($subDepartmentInfo['id'])) { ?>
            <form role="form" id="addOrganization" action="<?php echo base_url('updatesubdepartment') ?>" method="post" role="form">
            <?php } else { ?>
              <form role="form" id="addOrganization" action="<?php echo base_url('sub-department') ?>" method="post" role="form">
              <?php } ?>
              <div class="box-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label for="fname">Department Name*</label>
                      <select class="form-control" id="department" name="dept_name" required="">
                        <option value="">Select Department</option>
                        <?php if (!empty($departmentList)) { ?>
                          <?php foreach ($departmentList as $key => $dept) { ?>
                            <option <?php
                            if (isset($subDepartmentInfo['dept_id']) && ($subDepartmentInfo['dept_id'] == $dept['dept_id'])) {
                              echo 'selected';
                            }
                            ?> value="<?php echo $dept['dept_id'] ?>"> <?php echo $dept['dept_name']; ?></option>>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="fname">Sub Department Name*</label>
                      <input type="text" class="form-control required"  required="" value="<?php echo isset($subDepartmentInfo['sub_dept_name']) ? $subDepartmentInfo['sub_dept_name'] : ''; ?>" id="subdeptname" name="subdeptname" maxlength="128">
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-12">
                    <?php echo validation_errors('<div class="alert alert-danger alert-dismissable">', ' <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button></div>'); ?>
                  </div>
                </div>
              </div><!-- /.box-body -->
              <div class="box-footer">
                <input type="submit" class="btn btn-primary" value="<?php echo isset($subDepartmentInfo['id']) ? 'Update' : 'Add'; ?>" />
                <input type="reset" class="btn btn-default" value="Reset" />
                <input type="hidden" name="sub_department_id" value="<?php echo isset($subDepartmentInfo['id']) ? $subDepartmentInfo['id'] : ''; ?>">
              </div>
            </form>
        </div>
      </div>
      <div class="col-md-6">
        <div class="box box-primary">
          <div class="box-body">
            <table class="table" id="subdepartmentlisttbl">
              <thead>
                <tr>
                  <th>Id</th>
                  <th>Sub Department Name</th>
                  <th>Department Name</th>

                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<script>
  $("#department").select2({
  });

</script>
