<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Shift Management
      <small>Add / Edit Shift</small>
    </h1>
  </section>
  <section class="content">
    <div class="row">
      <!-- left column -->
      <div class="col-md-6">
        <!-- general form elements -->
        <?php
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>
        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Shift Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <?php if (isset($shiftInfo['id'])) { ?>
            <form role="form" id="addShift" action="<?php echo base_url('updateshift') ?>" method="post" role="form">
            <?php } else { ?>
              <form role="form" id="addShift" action="<?php echo base_url('shift') ?>" method="post" role="form">
              <?php } ?>
              <div class="box-body">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="fname">Department Name*</label>
                      <select class="form-control" id="department" onchange="getsubdepartmentlist(this.value, <?php $this->session->userdata('organization_id') ?>)" name="dept_name" required="">
                        <option value="">Select Department</option>
                        <?php if (!empty($departmentList)) { ?>
                          <?php foreach ($departmentList as $key => $dept) { ?>
                            <option <?php
                            if (isset($shiftInfo['dept_id']) && ($shiftInfo['dept_id'] == $dept['dept_id'])) {
                              echo 'selected';
                            }
                            ?> value="<?php echo $dept['dept_id'] ?>"> <?php echo $dept['dept_name']; ?></option>>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>

                    <div class="form-group">
                      <label for="fname">Sub Department Name*</label>
                      <select class="form-control" id="subdepartment" onchange="getSupervisorListBySubDept(this.value)" name="sub_dept_name" required="">
                        <option value="">Select Sub Department</option>
                        <?php if (!empty($subDepartmentList)) { ?>
                          <?php foreach ($subDepartmentList as $key => $subDept) { ?>
                            <option <?php
                            if (isset($shiftInfo['sub_dept_id']) && ($shiftInfo['sub_dept_id'] == $subDept['id'])) {
                              echo 'selected';
                            }
                            ?> value="<?php echo $subDept['id'] ?>"> <?php echo $subDept['sub_dept_name']; ?></option>>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>

                    <div class="form-group">
                      <label for="fname">Shift Mngt *</label>
                      <select class="form-control" id="supervisor" name="supervisor_name" required="">
                        <option value="">Select Shift Mngt</option>
                        <?php if (!empty($shiftMngtList)) { ?>
                          <?php foreach ($shiftMngtList as $key => $shiftMngt) { ?>
                            <option <?php
                            if (isset($shiftInfo['superviser_id']) && ($shiftInfo['superviser_id'] == $shiftMngt['id'])) {
                              echo 'selected';
                            }
                            ?> value="<?php echo $shiftMngt['id'] ?>"> <?php echo $shiftMngt['shift_name']; ?></option>>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>

                    <div class="form-group">
                      <label for="fname">Shift</label>
                      <select class="form-control" id="shift" name="shift" required="">
                        <option value="">Select Shift</option>
                        <?php if (!empty($shiftList)) { ?>
                          <?php foreach ($shiftList as $key => $shift) { ?>
                            <option <?php
                            if (isset($shiftInfo['shift']) && ($shiftInfo['shift'] == $shift['id'])) {
                              echo 'selected';
                            }
                            ?> value="<?php echo $shift['id'] ?>"> <?php echo $shift['shift_name']; ?></option>>
                            <?php } ?>
                          <?php } ?>
                      </select>
                    </div>

                    <div class="form-group">
                      <label for="fname">Benchmark</label>
                      <input type="text" class="form-control required"  required="" value="<?php echo isset($shiftInfo['in_time']) ? $shiftInfo['in_time'] : ''; ?>" id="banchmark" name="banchmark" maxlength="128">
                    </div>


                  </div>

                </div>
              </div><!-- /.box-body -->
              <div class="box-footer">
                <input type="submit" class="btn btn-primary" value="<?php echo isset($shiftInfo['id']) ? 'Update' : 'Add'; ?>" />
                <input type="reset" class="btn btn-default" value="Reset" />
                <input type="hidden" name="shift_id" value="<?php echo isset($shiftInfo['id']) ? $shiftInfo['id'] : ''; ?>">
              </div>
            </form>
        </div>
      </div>
      <div class="col-md-6">
        <div class="box box-primary">
          <div class="box-body">
            <table class="table" id="shiftlisttbl">
              <thead>
                <tr>
                  <th>Id</th>
                  <th>Department Name</th>
                  <th>Sub Department Name</th>
                  <th>Superviser Name</th>
                  <th>Shift Name</th>
                  <th>In Time</th>
                  <th>Out Time</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
