<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Clients Management
      <small>Add / Edit </small>
    </h1>
  </section>

  <section class="content">

    <div class="row">
      <!-- left column -->
      <div class="col-md-6">
        <!-- general form elements -->
        <?php
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>

        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Clients Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <?php if (isset($clientInfo['id'])) { ?>
            <form role="form" id="addClient" action="<?php echo base_url('updateclient/' . $clientInfo['id']) ?>" method="post" role="form">
            <?php } else { ?>
              <form role="form" id="addClient" action="<?php echo base_url('clients') ?>" method="post" role="form">
              <?php } ?>
              <div class="box-body">

                <div class="row">

                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="fname">Client Name</label>
                      <input type="text" autocomplete="off" class="form-control required"  required="" value="<?php echo isset($clientInfo['client']) ? $clientInfo['client'] : set_value('client'); ?>" id="clients" name="client" maxlength="128">
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6">

                    <div class="form-group">
                      <label for="client_code">Client Code</label>
                      <input type="text" autocomplete="off" class="form-control required"  required="" value="<?php echo isset($clientInfo['client_code']) ? $clientInfo['client_code'] : set_value('client_code'); ?>" id="client_code" name="client_code" maxlength="128">
                    </div>
                  </div>
                </div>


              </div><!-- /.box-body -->

              <div class="box-footer">
                <input type="submit" class="btn btn-primary" value="<?php echo isset($clientInfo['id']) ? 'Update' : 'Add'; ?>" />
                <input type="reset" class="btn btn-default" value="Reset" />
                <input type="hidden" name="client_id" value="<?php echo isset($clientInfo['id']) ? $clientInfo['id'] : ''; ?>">
              </div>
            </form>
        </div>
        <div class="col-md-12">
          <?php
          $this->load->helper('form');
          $error = $this->session->flashdata('error');
          if ($error) {
            ?>
            <div class="alert alert-danger alert-dismissable">
              <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
              <?php echo $this->session->flashdata('error'); ?>
            </div>
          <?php } ?>
          <?php
          $success = $this->session->flashdata('success');
          if ($success) {
            ?>
            <div class="alert alert-success alert-dismissable">
              <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
              <?php echo $this->session->flashdata('success'); ?>
            </div>
          <?php } ?>

          <div class="row">
            <div class="col-md-12">
              <?php echo validation_errors('<div class="alert alert-danger alert-dismissable">', ' <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button></div>'); ?>
            </div>
          </div>
        </div>
      </div>

      <div class="col-md-6">
        <div class="box box-primary">
          <div class="box-body">
            <table class="table" id="clientlisttbl">
              <thead>
                <tr>
                  <th>Sr no</th>
                  <th>Client Name</th>
                  <th>Client Code</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>


              </tbody>
            </table>
          </div>
        </div>
      </div>


    </div>
  </section>

</div>
<script type="text/javascript">
  jQuery(document).ready(function () {

    $("#client-tbl").DataTable().destroy();
    $("#client-tbl").DataTable({

    });

  });


</script>
