<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : User (UserController)
 * User Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class SupervisorMngtController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->load->model('SupervisorMngt_model', 'supervisormngt_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function delSubDeptMngt($shiftId) {
    $this->db->where('id', $shiftId);
    $this->db->update('tbl_sub_dept_mngt', ['isDeleted' => '1']);
//last_query();
    $this->session->set_flashdata('success', 'Sub Department Mngt Deleted Successfully');
    redirect(site_url('sub-dept-mngt'));
  }

  function getShiftMgmtListBySubDeptId() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $subDeptId = $this->input->post('subDeptId');
      $shiftList = $this->subdeptmngt_model->getShiftListBySubDeptId($subDeptId);
//pre($shiftList);
      $html = "<option value=''>Select Shift</option>";
      if (!empty($shiftList)) {
        foreach ($shiftList as $key => $shift) {
          $html .= "<option value='" . $shift['id'] . "'>" . $shift['shift_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function SuperMngt($subDeptMngt = '') {
//pre($this->input->post());
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {

      if ($this->input->post()) {
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        $this->form_validation->set_rules('sub_dept_name', 'Sub Department Name', 'required');
        $this->form_validation->set_rules('siftmngtid', 'Shift Name', 'required');
        $this->form_validation->set_rules('client', 'Client Name', 'required');
        $this->form_validation->set_rules('banchmark', 'Banchmark', 'required');
        if ($this->form_validation->run() === TRUE) {
          $orgId = $this->organization_id;
          $deptId = $this->input->post('dept_name');
          $subDeptId = $this->input->post('sub_dept_name');
          $siftmngtid = $this->input->post('siftmngtid');
          $clientId = $this->input->post('client');
          $banchmark = $this->input->post('banchmark');
          $this->db->insert('tbl_sub_dept_mngt', ['dept_id' => $deptId, 'sub_dept_id' => $subDeptId, 'org_id' => $orgId, 'shift_mngt_id' => $siftmngtid, 'client_id' => $clientId, 'banchmark' => $banchmark]);
          $this->session->set_flashdata('success', 'New Shift Created Successfully');
          redirect(site_url('sub-dept-mngt'));
        }
      }
      if ($subDeptMngt) {
        $data['subDeptMngtInfo'] = $this->subdeptmngt_model->getSubDeptMngtInfo($subDeptMngt);
      }
      $orgId = '';
      if (in_array($this->role, ['2', '4', '5', '6', '8', '9', '14', '11', '12'])) {
        $orgId = $this->organization_id;
      }

      $this->global['pageTitle'] = 'Searbird : Sub Department Management';
      $data['departmentList'] = $departmentList = $this->user_model->getDepartmentList($orgId);
      $deptId = isset($departmentList[0]['dept_id']) ? $departmentList[0]['dept_id'] : '';
      $data['subDepartmentList'] = $subDepartmentList = $this->user_model->getSubDepartmentList($deptId, $subDepartmentId = '', $withManPowerCount = '0');
//pre($data);
      $subDeptId = isset($subDepartmentList[0]['id']) ? $subDepartmentList[0]['id'] : '';
      $data['shiftMngtList'] = shiftMngtByDeptIdSubDeptId($deptId, $subDeptId);

      $data['organizedClientsList'] = getOrganizedClient();
      $this->loadViews("supervisor-mngt-view", $this->global, $data, NULL);
    }
  }

  function shiftMngtAjax() {
    if (!in_array($this->role, ['1', '2', '5', '8', '9', '10', '11', '12', '13', '14'])) {
      $this->loadThis();
    } else {
      $subDeptId = $this->input->post('subDeptId');
      $shiftMngtList = shiftMngtByDeptIdSubDeptId($deptId, $subDeptId);
//pre($shiftMngtList);
      $html = "<option value=''>Select Shift Mangt</option>";
      if (!empty($shiftMngtList)) {
        foreach ($shiftMngtList as $key => $shiftMngt) {
          $html .= "<option value='" . $shiftMngt['id'] . "'>" . $shiftMngt['shift_name'] . "</option>";
        }
      }
      echo json_encode($html);
    }
  }

  function updateshift() {
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
      $shiftId = $this->input->post('shift_id');
      if ($this->input->post()) {
        $this->form_validation->set_rules('dept_name', 'Department Name', 'required');
        $this->form_validation->set_rules('sub_dept_name', 'Sub Department Name', 'required');
        $this->form_validation->set_rules('supervisor_name', 'Supervisor Name', 'required');
        $this->form_validation->set_rules('shift', 'Shift', 'required');
        $this->form_validation->set_rules('shift_in_time', 'Shift in Time', 'required');
        $this->form_validation->set_rules('shift_out_time', 'Shift out Time', 'required');
        if ($this->form_validation->run() === TRUE) {
          $orgId = $this->organization_id;
          $deptId = $this->input->post('dept_name');
          $subDeptId = $this->input->post('sub_dept_name');
          $supervisorId = $this->input->post('supervisor_name');
          $shift = $this->input->post('shift');
          $shiftInTime = $this->input->post('shift_in_time');
          $shiftOutTime = $this->input->post('shift_out_time');
          $this->db->where('id', $shiftId);
          $this->db->update('shift_mgmt', ['dept_id' => $deptId, 'sub_dept_id' => $subDeptId, 'superviser_id' => $supervisorId, 'shift' => $shift, 'in_time' => $shiftInTime, 'out_time' => $shiftOutTime]);
          $this->session->set_flashdata('success', 'Sub Department updated successfully');
          redirect(site_url('shift'));
          exit;
        }
      }
      redirect(site_url('shift'));
    }
  }

  function getSupervisorMngtlist() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $this->db->from('tbl_sub_dept_mngt');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.isDeleted', '0');
    $this->db->where('tbl_users.createdBy', $this->session->userdata('userId'));
    $this->db->where('tbl_sub_dept_mngt.org_id', $this->organization_id);
    $this->db->group_by('tbl_users.userId');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_sub_dept_mngt.dept_id', 'left');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = tbl_sub_dept_mngt.sub_dept_id', 'left');
    $this->db->join('shift_mgmt', 'shift_mgmt.id = tbl_sub_dept_mngt.shift_mngt_id', 'left');
    $this->db->join('tbl_users', 'tbl_users.userId = shift_mgmt.superviser_id', 'Right');
    $this->db->join('tbl_organization', 'tbl_organization.id = tbl_sub_dept_mngt.org_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
    if ($search != '') {
      $likeCriteria = "(tbl_sub_dept_mngt.banchmark  LIKE '%" . $search . "%' "
          . " OR tbl_departments.dept_name  LIKE '%" . $search . "%' "
          . " OR tbl_organization.org_name  LIKE '%" . $search . "%' "
          . " OR tbl_users.name  LIKE '%" . $search . "%' "
          . " OR tbl_clients.client  LIKE '%" . $search . "%' "
          . " OR tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%' "
          . "OR  shift_mgmt.shift  LIKE '%" . $search . "%')";
    }
    $totalrows = $this->db->get()->num_rows();
    $this->db->select(
        'tbl_organization.org_name,'
        . 'tbl_users.name,tbl_clients.client,'
        . 'tbl_sub_dept_mngt.id,'
        . 'tbl_sub_departments.sub_dept_name,'
        . 'tbl_shift.shift_name,'
        . 'shift_mgmt.in_time,'
        . 'shift_mgmt.out_time,'
        . 'shift_mgmt.shift,'
        . 'tbl_departments.dept_name,'
        . 'tbl_organization.client_id as clientIds,'
        . 'tbl_users.userId as supervisorId,'
        . 'tbl_sub_dept_mngt.banchmark,'
        . 'tbl_users.userId,'
        . 'tbl_users.createdBy'
    );
    $this->db->from('tbl_sub_dept_mngt');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.org_id', $this->organization_id);
    $this->db->where('tbl_users.createdBy', $this->session->userdata('userId'));
    $this->db->group_by('tbl_users.userId');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_sub_dept_mngt.dept_id', 'left');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = tbl_sub_dept_mngt.sub_dept_id', 'left');
    $this->db->join('shift_mgmt', 'shift_mgmt.id = tbl_sub_dept_mngt.shift_mngt_id', 'left');
    $this->db->join('tbl_users', 'tbl_users.userId = shift_mgmt.superviser_id', 'Right');
    $this->db->join('tbl_organization', 'tbl_organization.id = tbl_sub_dept_mngt.org_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
    if ($search != '') {
      $likeCriteria = "(tbl_sub_dept_mngt.banchmark  LIKE '%" . $search . "%' "
          . " OR tbl_departments.dept_name  LIKE '%" . $search . "%' "
          . " OR tbl_organization.org_name  LIKE '%" . $search . "%' "
          . " OR tbl_users.name  LIKE '%" . $search . "%' "
          . " OR tbl_clients.client  LIKE '%" . $search . "%' "
          . " OR tbl_sub_departments.sub_dept_name  LIKE '%" . $search . "%' "
          . "OR  shift_mgmt.shift  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $results = $query->result_array();
//    pre($results);
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $shift) {
        $attr = array();
        $attr[] = $shift['id'];
        $attr[] = $shift['name'];
        $attr[] = $shift['org_name'];
        $attr[] = clientsListArray($shift['supervisorId']);
        $attr[] = departmentList($shift['supervisorId']);
        $attr[] = subDepartmentList($shift['supervisorId']);
//        $attr[] = $shift['banchmark'];
        $attr[] = shiftList($shift['supervisorId']);
// $attr[] = '<a href="' . site_url('sub-dept-mngt/' . $shift['id']) . '" class="btn btn-sm btn-primary"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a><a onclick="return confirm(\'Are you sure\')" href="' . site_url('delshiftmngt/' . $shift['id']) . '" style="margin-left:5px" class="btn btn-sm btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';
        $data[] = $attr;
      }
    }
    $output = array(
      "draw" => $draw,
      "recordsTotal" => $totalrows,
      "recordsFiltered" => $totalrows,
      "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function getProductivityUploadingFormat() {
    $supervisorId = $this->session->userdata('userId');
    $shiftMngtArray = getShiftMngtBySupervisor($supervisorId);
//    pre($this->input->post());

    $filename = clientName($this->input->post('clientId')) . "-" . deptName($this->input->post('departmentId')) . "-" . subDeptName($this->input->post('subdepartment')) . "-" . shiftName($this->input->post('shift')) . '.xls';
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
//$filename = 'manpower_productivity.xls';
      $this->load->library('excel');
      $this->excel->setActiveSheetIndex(0);
      $this->excel->getActiveSheet()->setTitle('Report');
      $this->excel->getActiveSheet()->setCellValue('A1', 'Employee Name')->getStyle('A1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('B1', 'Employee Code')->getStyle('B1')->getFont()->setBold(true);
      if (deptName($this->input->post('departmentId')) == 'Inward' || subDeptName($this->input->post('subdepartment')) == 'Inward') {
        $this->excel->getActiveSheet()->setCellValue('C1', 'GRN')->getStyle('C1')->getFont()->setBold(true);
      } else {
        $this->excel->getActiveSheet()->setCellValue('C1', 'Challan')->getStyle('C1')->getFont()->setBold(true);
      }
      $this->excel->getActiveSheet()->setCellValue('D1', 'Boxes')->getStyle('D1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E1', 'Qty')->getStyle('E1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('F1', 'SKU')->getStyle('F1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('G1', 'KG')->getStyle('G1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('H1', 'CFC')->getStyle('H1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('I1', 'BINS')->getStyle('I1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('J1', 'PALLET')->getStyle('J1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('K1', 'LINE')->getStyle('K1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('L1', 'Remark')->getStyle('L1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('M1', 'Shift')->getStyle('M1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('N1', 'TW_Hour(24hr)')->getStyle('N1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('O1', 'from Time(24hr)')->getStyle('O1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('P1', 'to Time(24hr)')->getStyle('P1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('Q1', 'Report Date')->getStyle('Q1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('R1', 'Client')->getStyle('R1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('S1', 'Department')->getStyle('S1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('T1', 'Sub Department')->getStyle('T1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('U1', 'WL Id')->getStyle('U1')->getFont()->setBold(true);

      date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)
//      $todayDate = date('Y-m-d');
      $todayDate = $this->input->post('date');
//    $client_list = $this->db->from('tbl_clients')->get()->result_array();
//$all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=' . $this->input->post('team_id') . ')')->result();
      $currentStatus = "'1'";
      $selectQuery = 'SELECT '
          . ' wl.id, '
          . ' wl.check_in, '
          . ' wl.check_out, '
          . ' wl.dept_id, '
          . ' wl.sub_dept_id, '
          . 'SEC_TO_TIME((TIME_TO_SEC(wl.check_out) - TIME_TO_SEC(wl.check_in))) AS `total_hours`,'
          . 'U.roleId AS user_role,'
          . 'U.designation, '
          . 'U.userId AS user_id, '
          . 'U.name AS employee_name, '
          . 'U.emp_code AS employee_code, '
          . 'U.email AS employee_email, '
          . 'U.userId AS employee_id, '
          . 'U.emp_code AS employee_code,'
          . ' U.current_status, '
          . ' (SELECT dept_name from `tbl_departments` where `dept_id`= wl.dept_id) as department_name, '
          . ' (SELECT sub_dept_name from `tbl_sub_departments` where `id`= wl.sub_dept_id) as sub_department_name FROM tbl_users AS U '
          . ' left Join working_logs wl on wl.user_id = U.userId'
//              . '  right Join working_logs wl on wl.user_id = U.userId'
//              . ' WHERE U.current_status = ' . $currentStatus . ' AND U.sub_department_id = ' . $this->input->post('subdepartment') . ' AND U.department_id = ' . $this->input->post('departmentId') . ' AND U.userId != ' . $supervisorId . ' and organization_id = ' . $this->organization_id . ' and U.roleId = 3 and wl.check_in like "' . $todayDate . '%"';
          . ' WHERE wl.superviser_id = ' . $this->session->userdata('userId') . ' AND wl.sub_dept_id = ' . $this->input->post('subdepartment') . ' AND wl.client_id = ' . $this->input->post('clientId') . '  AND wl.dept_id = ' . $this->input->post('departmentId') . ' AND U.userId != ' . $supervisorId . ' AND U.current_status = "' . 1 . '" and wl.org_id = ' . $this->organization_id . ' and U.roleId = 3 and wl.check_in like "' . $todayDate . '%"';
//      die;
      $teamArray = $this->db->query($selectQuery)->result();
    //  last_query();
//      pre($teamArray);
//      $teamArray = supervisorPresentTeam($this->input->post('departmentId'), $this->input->post('subdepartment'), $this->session->userdata('userId'), $this->organization_id);

      if (!empty($teamArray)) {
        $excelrow = 2;
        foreach ($teamArray as $team) {
//pre($team);
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, $team->employee_name);
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $team->employee_code);
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, '');
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, shiftName($this->input->post('shift')));
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($team->check_in && $team->check_out) ? date('H:i', strtotime($team->total_hours)) : '');
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, date('Y-m-d H:i', strtotime($team->check_in)));
          $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $team->check_out ? date('Y-m-d H:i', strtotime($team->check_out)) : '');
          $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $todayDate);
          $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, clientName($this->input->post('clientId')) . '=>' . $this->input->post('clientId'));
          $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, deptName($this->input->post('departmentId')) . '=>' . $this->input->post('departmentId'));
          $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, subDeptName($this->input->post('subdepartment')) . '=>' . $this->input->post('subdepartment'));
          $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, $team->id);
//          $this->excel->getActiveSheet()->setCellValue('V' . $excelrow, $team->id);
//$this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALTIME);
//fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;
        }
//}
//        header('Content-Type: application/vnd.ms-excel'); //mime type
//        header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
//        header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
//        $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
//        $objWriter->save('php://output');
//        die;
//        exit;
//}
      }



      header('Content-Type: application/vnd.ms-excel'); //mime type
      header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
      header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
      $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
      $objWriter->save('php://output');
      die;
      exit;
    }
  }

  function getProductivityUploadingFormatCO() {
    $supervisorId = $this->session->userdata('userId');
    $shiftMngtArray = getShiftMngtBySupervisor($supervisorId);
//    pre($shiftMngtArray);

    $filename = clientName($this->input->post('clientId')) . "-" . deptName($this->input->post('departmentId')) . "-" . subDeptName($this->input->post('subdepartment')) . "-" . shiftName($this->input->post('shift')) . '.xls';
    if (!in_array($this->role, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'])) {
      $this->loadThis();
    } else {
//$filename = 'manpower_productivity.xls';
      $this->load->library('excel');
      $this->excel->setActiveSheetIndex(0);
      $this->excel->getActiveSheet()->setTitle('Report');
      $this->excel->getActiveSheet()->setCellValue('A1', 'Employee Name')->getStyle('A1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('B1', 'Employee Code')->getStyle('B1')->getFont()->setBold(true);
      if (deptName($this->input->post('departmentId')) == 'Inward' || subDeptName($this->input->post('subdepartment')) == 'Inward') {
        $this->excel->getActiveSheet()->setCellValue('C1', 'GRN')->getStyle('C1')->getFont()->setBold(true);
      } else {
        $this->excel->getActiveSheet()->setCellValue('C1', 'Challan')->getStyle('C1')->getFont()->setBold(true);
      }
      $this->excel->getActiveSheet()->setCellValue('D1', 'Boxes')->getStyle('D1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E1', 'Qty')->getStyle('E1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('F1', 'SKU')->getStyle('F1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('G1', 'KG')->getStyle('G1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('H1', 'CFC')->getStyle('H1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('I1', 'BINS')->getStyle('I1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('J1', 'PALLET')->getStyle('J1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('K1', 'LINE')->getStyle('K1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('L1', 'Remark')->getStyle('L1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('M1', 'Shift')->getStyle('M1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('N1', 'TW_Hour(24hr)')->getStyle('N1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('O1', 'from Time(24hr)')->getStyle('O1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('P1', 'to Time(24hr)')->getStyle('P1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('Q1', 'Report Date')->getStyle('Q1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('R1', 'Client')->getStyle('R1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('S1', 'Department')->getStyle('S1')->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('T1', 'Sub Department')->getStyle('T1')->getFont()->setBold(true);
//      $this->excel->getActiveSheet()->setCellValue('T1', 'WL Id')->getStyle('T1')->getFont()->setBold(true);

      date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)
      $todayDate = $this->input->post('date');
//    $client_list = $this->db->from('tbl_clients')->get()->result_array();
//$all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=' . $this->input->post('team_id') . ')')->result();
      $currentStatus = "'1'";
      $excelrow = 2;
      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, '');
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, shiftName($this->input->post('shift')));
      $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, ($shiftMngtArray['in_time'] && $shiftMngtArray['in_time']) ? date('H:i', strtotime($shiftMngtArray['total_hours'])) : '');
      $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $todayDate . ' ' . date('H:i', strtotime($shiftMngtArray['in_time'])));
      $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $shiftMngtArray['out_time'] ? $todayDate . ' ' . date('H:i', strtotime($shiftMngtArray['out_time'])) : '');
      $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $todayDate);
      $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, clientName($this->input->post('clientId')) . '=>' . $this->input->post('clientId'));
      $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, deptName($this->input->post('departmentId')) . '=>' . $this->input->post('departmentId'));
      $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, subDeptName($this->input->post('subdepartment')) . '=>' . $this->input->post('subdepartment'));
//      $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, subDeptName($this->input->post('subdepartment')) . '=>' . $this->input->post('subdepartment'));
//      $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, $team->id);
//$this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALTIME);
//fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
      $excelrow++;

      header('Content-Type: application/vnd.ms-excel'); //mime type
      header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
      header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
      $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
      $objWriter->save('php://output');
      die;
      exit;
    }
  }

  function getFileName() {
    $filename = clientName($this->input->post('clientId')) . "-" . deptName($this->input->post('departmentId')) . "-" . subDeptName($this->input->post('subdepartment')) . "-" . shiftName($this->input->post('shift'));
    echo json_encode($filename);
  }

}
