<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Report (ReportController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class ReportController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function view_report_new_one_c_l() {

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }

    if ($this->role == 10) {
      $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
      $this->db->where_in('id', $lientIdsArray);
      $clientList = $this->db->get('tbl_clients')->result_array();
    } else {
      $clientList = $this->db->get('tbl_clients')->result_array();
    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    if ($this->role == '12') {
      $locationList = $this->db->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')->where('client_id', $clientId)->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('loc_id', $locationId)->get('tbl_organization')->result_array();
    }
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;

    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_one_c_l", $this->global, $data, NULL);
  }

  function get_date_ranged_report_excel_new_one_l_w_c() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift_id = shiftTimeBySubDept($sub_department_id, $this->session->userdata('userId'))->shift;
    } else {
      // pre($this->input->post());
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'one_view_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'one_view_productivity_report_' . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo shiftName($shift_id);
    //echo subDeptName($sub_department_id);
    //die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Report Type')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', ($client_id && $client_id != 'all') ? clientName($client_id) . " Clients Of " . orgName($organization_id) : "All Clients Of " . orgName($organization_id))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Date Range')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', $fromDate . '_to_' . $toDate)->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Report Generated Date & Time')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', date("Y-m-d H:i:s"))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Location')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B4', 'Warehouse')->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C4', 'Client')->getStyle('C4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D4', 'No. of Department')->getStyle('D4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E4', 'No. of Sub Department')->getStyle('E4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F4', 'Total Banchmark')->getStyle('F4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G4', 'Toatal Challan')->getStyle('G4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H4', 'Total Boxes')->getStyle('H4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I4', 'Total Qty')->getStyle('I4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J4', 'Total SKU')->getStyle('J4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K4', 'Total KG')->getStyle('K4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L4', 'Total CFC')->getStyle('L4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M4', 'Total Bins')->getStyle('M4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N4', 'Total Pallet')->getStyle('N4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O4', 'Total Manpower')->getStyle('O4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P4', 'per Person Productivity')->getStyle('P4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q4', '% age Achievement')->getStyle('Q4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R4', 'Total Working Hour')->getStyle('R4')->getFont()->setBold(true);
    $fBanchmark = 0;
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 5;
      $where = ' ';
      $select = ' ';
      $groupBY = ' GROUP BY client';

      if ($shift_id != '' && $shift_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.shift = "' . shiftName($shift_id) . '" ';
        $groupBY = ' GROUP BY shift';
      } elseif ($shift_id == 'all') {
        $groupBY = ' GROUP BY shift';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      $groupBY = ' GROUP BY client';

      $total_challans = $this->db->query('SELECT *, IFNULL(count(distinct dept_id), 0) AS total_no_of_dept,IFNULL(count(distinct sub_dept_id), 0) AS total_no_of_sub_dept,IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      //last_query();
      //pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-one-c-l-w-d-sd');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $totalArray = [];
          $fBanchmark += $totalArray['banchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(locationName($location_id)));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(orgName($organization_id)));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, ucfirst(clientName($challan['client'])));
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['total_no_of_dept']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['total_no_of_sub_dept']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALBANCHMARK);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $TOTALMANPOWER);
          $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, round(($totalArray[$uomKey] / $TOTALMANPOWER), '2'));
          $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, round(((($totalArray[$uomKey]) * 100) / $TOTALBANCHMARK), '2') . ' %');
          $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $total_time[$key1]['total_time']);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fDeptCount);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fSubDeptCount);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBanchmark);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $fEmp);
      $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_one_l_w() {
//    echo 'jkjkj';
//    die;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift_id = shiftTimeBySubDept($sub_department_id, $this->session->userdata('userId'))->shift;
    } else {
      // pre($this->input->post());
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'one_view_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'one_view_productivity_report_' . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo shiftName($shift_id);
    //echo subDeptName($sub_department_id);
    //die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Report Type')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', ($organization_id && $organization_id != 'all') ? orgName($organization_id) : "All Warehouses")->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Date Range')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', $fromDate . '_to_' . $toDate)->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Report Generated Date & Time')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', date("Y-m-d H:i:s"))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Location')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B4', 'Warehouse')->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C4', 'No. of Clients')->getStyle('C4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D4', 'No. of Departments')->getStyle('D4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E4', 'No. of Sub Departments')->getStyle('E4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F4', 'Total Banchmark')->getStyle('F4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G4', 'Toatal Challan')->getStyle('G4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H4', 'Total Boxes')->getStyle('H4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I4', 'Total Qty')->getStyle('I4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J4', 'Total SKU')->getStyle('J4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K4', 'Total KG')->getStyle('K4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L4', 'Total CFC')->getStyle('L4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M4', 'Total Bins')->getStyle('M4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N4', 'Total Pallet')->getStyle('N4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O4', 'Total Manpower')->getStyle('O4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P4', 'per Person Productivity')->getStyle('P4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q4', '% age Achievement')->getStyle('Q4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R4', 'Total Working Hours')->getStyle('R4')->getFont()->setBold(true);
    $fBanchmark = 0;
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 5;
      $where = ' ';
      $select = ' ';
      $groupBY = ' GROUP BY org';

      if ($shift_id != '' && $shift_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.shift = "' . shiftName($shift_id) . '" ';
        $groupBY = ' GROUP BY shift';
      } elseif ($shift_id == 'all') {
        $groupBY = ' GROUP BY shift';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      $groupBY = ' GROUP BY org';

      $total_challans = $this->db->query('SELECT *, IFNULL(count(distinct client), 0) AS total_no_of_client, IFNULL(count(distinct dept_id), 0) AS total_no_of_dept,IFNULL(count(distinct sub_dept_id), 0) AS total_no_of_sub_dept,IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      //last_query();
      //pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-one-c-l-w-d-sd');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $fDeptCount += $challan['total_no_of_dept'];
          $fSubDeptCount += $challan['total_no_of_sub_dept'];
          $fClientCount += $challan['total_no_of_client'];
          $totalArray = [];
//          pre($challan['total_challans']);
          $fBanchmark += $totalArray['benchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
//          pre($totalArray);
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(locationName($location_id)));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(orgName($organization_id)));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['total_no_of_client']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['total_no_of_dept']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['total_no_of_sub_dept']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALBANCHMARK);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $TOTALMANPOWER);
          $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, round(($totalArray[$uomKey] / $TOTALMANPOWER), '2'));
          $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, round(((($totalArray[$uomKey]) * 100) / $TOTALBANCHMARK), '2') . ' %');
          $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $total_time[$key1]['total_time']);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fClientCount);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fDeptCount);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fSubDeptCount);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBanchmark);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $fEmp);
      $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_one_l() {
//    echo 'jkjkj';
//    die;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift_id = shiftTimeBySubDept($sub_department_id, $this->session->userdata('userId'))->shift;
    } else {
      // pre($this->input->post());
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'one_view_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'one_view_productivity_report_' . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo shiftName($shift_id);
    //echo subDeptName($sub_department_id);
    //die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Report Type')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', ($location_id && $location_id != 'all') ? locationName($location_id) : "All Locations")->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Date Range')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', $fromDate . '_to_' . $toDate)->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Report Generated Date & Time')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', date("Y-m-d H:i:s"))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Location')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B4', 'No. of Warehouses')->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C4', 'No. of Clients')->getStyle('C4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D4', 'No. of Departments')->getStyle('D4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E4', 'No. of Sub Departments')->getStyle('E4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F4', 'Total Banchmark')->getStyle('F4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G4', 'Toatal Challan')->getStyle('G4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H4', 'Total Boxes')->getStyle('H4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I4', 'Total Qty')->getStyle('I4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J4', 'Total SKU')->getStyle('J4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K4', 'Total KG')->getStyle('K4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L4', 'Total CFC')->getStyle('L4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M4', 'Total Bins')->getStyle('M4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N4', 'Total Pallet')->getStyle('N4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O4', 'Total Manpower')->getStyle('O4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P4', 'per Person Productivity')->getStyle('P4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q4', '% age Achievement')->getStyle('Q4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R4', 'Total Working Hours')->getStyle('R4')->getFont()->setBold(true);
    $fBanchmark = 0;
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 5;
      $where = ' ';
      $select = ' ';
      $groupBY = ' GROUP BY org';

      if ($shift_id != '' && $shift_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.shift = "' . shiftName($shift_id) . '" ';
        $groupBY = ' GROUP BY shift';
      } elseif ($shift_id == 'all') {
        $groupBY = ' GROUP BY shift';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      $groupBY = ' GROUP BY org';

      $total_challans = $this->db->query('SELECT *,IFNULL(count(distinct org), 0) AS total_no_of_org, IFNULL(count(distinct client), 0) AS total_no_of_client, IFNULL(count(distinct dept_id), 0) AS total_no_of_dept,IFNULL(count(distinct sub_dept_id), 0) AS total_no_of_sub_dept,IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      //last_query();
      //pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-one-c-l-w-d-sd');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $totalArray = [];
//          pre($challan['total_challans']);
          $fBanchmark += $totalArray['benchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
//          pre($totalArray);
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(locationName($location_id)));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $challan['total_no_of_org']);
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['total_no_of_client']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['total_no_of_dept']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['total_no_of_sub_dept']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALBANCHMARK);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $TOTALMANPOWER);
          $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, round(($totalArray[$uomKey] / $TOTALMANPOWER), '2'));
          $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, round(((($totalArray[$uomKey]) * 100) / $TOTALBANCHMARK), '2') . ' %');
          $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $total_time[$key1]['total_time']);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fClientCount);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fDeptCount);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fSubDeptCount);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBanchmark);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $fEmp);
      $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function view_report_new_one_c_l_w_d() {

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }

    if ($this->role == 10) {
      $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
      $this->db->where_in('id', $lientIdsArray);
      $clientList = $this->db->get('tbl_clients')->result_array();
    } else {
      $clientList = $this->db->get('tbl_clients')->result_array();
    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    if ($this->role == '12') {
      $locationList = $this->db->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')->where('client_id', $clientId)->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('loc_id', $locationId)->get('tbl_organization')->result_array();
    }
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;

    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_one_c_l_w_d", $this->global, $data, NULL);
  }

  function get_date_ranged_report_excel_new_one_c_l_w_d() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift_id = shiftTimeBySubDept($sub_department_id, $this->session->userdata('userId'))->shift;
    } else {
      // pre($this->input->post());
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'one_view_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'one_view_productivity_report_' . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo shiftName($shift_id);
    //echo subDeptName($sub_department_id);
    //die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:M1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:M2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:M3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Report Type')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:M4')->setCellValue('B4', ($department_id) ? deptName($department_id) : "All" . " | One View Productivity Report")->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Date Range')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:M5')->setCellValue('B5', $fromDate . '_to_' . $toDate)->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Report Generated Date & Time')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:M6')->setCellValue('B6', date("Y-m-d H:i:s"))->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Depertment')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B7', 'Total Benchmark')->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C7', 'Total Challan')->getStyle('C7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D7', 'Total Boxes')->getStyle('D7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E7', 'Toatal Qty')->getStyle('E7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F7', 'Total SKU')->getStyle('F7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G7', 'Total KG')->getStyle('G7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H7', 'Total CFC')->getStyle('H7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I7', 'Total Bins')->getStyle('I7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J7', 'Total Pallet')->getStyle('J7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K7', 'Total Manpower')->getStyle('K7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L7', 'Per Person Productivity')->getStyle('L7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M7', '% age Achievement')->getStyle('M7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N7', 'Total Working Hours')->getStyle('N7')->getFont()->setBold(true);
    $fBanchmark = 0;
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 8;
      $where = ' ';
      $select = ' ';
      $groupBY = ' GROUP BY sub_dept_id';

      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      $groupBY = ' GROUP BY dept_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      //last_query();
//      pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-one-c-l-w-d-sd');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $totalArray = [];
//          pre($challan['total_challans']);
          $fBanchmark += $totalArray['benchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
//          pre($totalArray);
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(DeptName($challan['dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $TOTALBANCHMARK);
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALMANPOWER);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, round(($totalArray[$uomKey] / $TOTALMANPOWER), '2'));
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, round(((($totalArray[$uomKey]) * 100) / $TOTALBANCHMARK), '2') . ' %');
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $total_time[$key1]['total_time']);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $fBanchmark);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $fEmp);
      $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function view_report_new_one_c_l_w_d_sd() {
//    echo 'hhhhhhh';
//    die;

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')
          ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
          ->where('tbl_location.isDeleted', '0')
          ->group_by('tbl_location.loc_id')
          ->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')
              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->where_in('loc_id', $this->session->userdata('location_id'))
              ->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('loc_id', $locationId)->where('isDeleted', '0')->get('tbl_organization')->result_array();
    }
    //last_query();
    //pre($warehouseList);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
//    if ($this->role == 10) {
//      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
//      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
    if (isset($warehouseList[0]['client_id'])) {
      $this->db->where_in('id', explode(',', $warehouseList[0]['client_id']));
    }
    $clientList = $this->db->get('tbl_clients')->result_array();
    //pre($clientList);
    //last_query();
//    } else {
//      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
//    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    //die;




    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;

    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_one_c_l_w_d_sd", $this->global, $data, NULL);
  }

  function get_date_ranged_report_excel_new_one() {
    //pre($this->input->post());
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shiftId = $this->input->post('shift');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      if ($shiftId != '') {
        $this->get_date_ranged_report_excel_new_one_c_l_w_d_sd_shift();
        die;
      } elseif ($sub_department_id != '') {
        $this->get_date_ranged_report_excel_new_one_c_l_w_d_sd();
        die;
      } elseif ($department_id != '') {
        $this->get_date_ranged_report_excel_new_one_c_l_w_d();
        die;
      } else if (($client_id != '')) {
        $this->get_date_ranged_report_excel_new_one_l_w_c();
        die;
      } else if (($organization_id != '')) {
        $this->get_date_ranged_report_excel_new_one_l_w();
        die;
      } else if (($location_id != '')) {

        $this->get_date_ranged_report_excel_new_one_l();
        die;
      }
    }
  }

  function get_date_ranged_report_excel_new_one_c_l_w_d_sd_shift() {
//    pre('hjhhjhjhjh');
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift_id = shiftTimeBySubDept($sub_department_id, $this->session->userdata('userId'))->shift;
    } else {
      //pre($this->input->post());
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'one_view_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'one_view_productivity_report_' . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo shiftName($shift_id);
    //echo subDeptName($sub_department_id);
    //die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Report Type')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', (shiftName($shift_id) == 'all' ? "All Shift of " . subDeptName($sub_department_id) . " Sub Department" : shiftName($shift_id) . " " . subDeptName($sub_department_id) . " Sub Department"))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date Range')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', $fromDate . '_to_' . $toDate)->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Report Generated Date & Time')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', date("Y-m-d H:i:s"))->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Sub Depertment Name')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B8', 'Shift')->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C8', 'Total Benchmark')->getStyle('C8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D8', 'Benchmark Unit (UOM)')->getStyle('D8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E8', 'Total Challan')->getStyle('E8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F8', 'Total Boxes')->getStyle('F8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G8', 'Toatal Qty')->getStyle('G8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H8', 'Total SKU')->getStyle('H8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I8', 'Total KG')->getStyle('I8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J8', 'Total CFC')->getStyle('J8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K8', 'Total Bins')->getStyle('K8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L8', 'Total Pallet')->getStyle('L8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M8', 'Total Manpower')->getStyle('M8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N8', 'Per Person Productivity')->getStyle('N8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O8', '% age Achievement')->getStyle('O8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('p8', 'Total Working Hours')->getStyle('p8')->getFont()->setBold(true);
    $fBanchmark = 0;
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 9;
      $where = ' ';
      $select = ' ';
      $groupBY = ' GROUP BY shift';

      if ($shift_id != '' && $shift_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.shift = "' . $shift_id . '" ';
//        $where .= ' AND tbl_manpower_team_performance.shift = "' . shiftName($shift_id) . '" ';
        $groupBY = ' GROUP BY shift';
      } elseif ($shift_id == 'all') {
        $groupBY = ' GROUP BY shift';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      $groupBY = ' GROUP BY shift';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//      last_query();
//      pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-one-c-l-w-d-sd');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $totalArray = [];
          $fBanchmark += $totalArray['banchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
//          pre($totalArray);
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(subDeptName($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, shiftName($challan['shift']));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TOTALBANCHMARK);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALMANPOWER);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, round(($totalArray[$uomKey] / $TOTALMANPOWER), '2'));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, round(((($totalArray[$uomKey]) * 100) / $TOTALBANCHMARK), '2') . ' %');
          $this->excel->getActiveSheet()->setCellValue('p' . $excelrow, $total_time[$key1]['total_time']);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fBanchmark);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $fEmp);
      $this->excel->getActiveSheet()->setCellValue('p' . $excelrow, secToTime($total));
//      $this->excel->getActiveSheet()->setCellValue('p' . $excelrow, (intval($total / 3600)) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_one_c_l_w_d_sd() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift_id = shiftTimeBySubDept($sub_department_id, $this->session->userdata('userId'))->shift;
    } else {
      // pre($this->input->post());
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'one_view_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'one_view_productivity_report_' . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    //echo shiftName($shift_id);
    //echo subDeptName($sub_department_id);
    //die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Report Type')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', subDeptName($sub_department_id) . " | One View Productivity Report")->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date Range')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', $fromDate . '_to_' . $toDate)->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Report Generated Date & Time')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', date("Y-m-d H:i:s"))->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Sub Depertment Name')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B8', 'Shift')->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C8', 'Total Benchmark')->getStyle('C8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D8', 'Benchmark Unit (UOM)')->getStyle('D8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E8', 'Total Challan')->getStyle('E8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F8', 'Total Boxes')->getStyle('F8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G8', 'Toatal Qty')->getStyle('G8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H8', 'Total SKU')->getStyle('H8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I8', 'Total KG')->getStyle('I8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J8', 'Total CFC')->getStyle('J8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K8', 'Total Bins')->getStyle('K8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L8', 'Total Pallet')->getStyle('L8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M8', 'Total Manpower')->getStyle('M8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N8', 'Per Person Productivity')->getStyle('N8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O8', '% age Achievement')->getStyle('O8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('p8', 'Total Working Hours')->getStyle('p8')->getFont()->setBold(true);
    $fBanchmark = 0;
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 9;
      $where = ' ';
      $select = ' ';
      $groupBY = ' GROUP BY sub_dept_id';

      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      $groupBY = ' GROUP BY sub_dept_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      //last_query();
//      pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-one-c-l-w-d-sd');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $uomKey = $challan['uom'];
          $totalArray = [];
          $fBanchmark += $totalArray['banchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(subDeptName($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst("All"));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TOTALBANCHMARK);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALMANPOWER);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, round(($totalArray[$uomKey] / $TOTALMANPOWER), '2'));
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, round(((($totalArray[$uomKey] ) * 100) / $TOTALBANCHMARK), '2') . ' %');
          $this->excel->getActiveSheet()->setCellValue('p' . $excelrow, $total_time[$key1]['total_time']);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fBanchmark);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $fEmp);
      $this->excel->getActiveSheet()->setCellValue('p' . $excelrow, secToTime($total));
//      $this->excel->getActiveSheet()->setCellValue('p' . $excelrow, (intval($total / 3600)) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function view_report_new_detailed_c_l_w_d() {

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')->where_in('loc_id', $this->session->userdata('location_id'))->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
              //->where('client_id', $clientId)
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';

    if ($this->role == 10) {
      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
      $clientList = $this->db->get('tbl_clients')->result_array();
    } else {
      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';

    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('client_id', $clientId)->get('tbl_organization')->result_array();
    }
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_detailed_c_l_w_d", $this->global, $data, NULL);
  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client Name')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:G1')->setCellValue('B1', clientName(clientIdByLocationId(locationIdByOrgId($organization_id))))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Location')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:G2')->setCellValue('B2', locationName(locationIdByOrgId($organization_id)))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Warehouse')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:G3')->setCellValue('B3', orgName($organization_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:G4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Date Range')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:G5')->setCellValue('B5', $fromDate . '_to_' . $toDate)->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B6', 'Total Challan')->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C6', 'Total Boxes')->getStyle('C6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D6', 'Toatal Qty')->getStyle('D6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E6', 'Total SKU')->getStyle('E6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F6', 'Total Manpower')->getStyle('F6')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 7;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY date';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;

          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALMANPOWER);

          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;
        }
      }
      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fEmp);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function view_report_new_detailed_c_l_w_d_sd() {


    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')
//              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
          ->where('tbl_location.isDeleted', '0')
          ->group_by('tbl_location.loc_id')
          ->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')
//                      ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
//                      ->where_in('loc_id', $this->session->userdata('location_id'))
              ->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
//                      ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '4'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
//      $warehouseList = $this->db->where('loc_id', $locationId)->where('isDeleted', '0')->get('tbl_organization')->result_array();
    }
    //last_query();
    //pre($warehouseList);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
//    if ($this->role == 10) {
//      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
//      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
    if (isset($warehouseList[0]['client_id'])) {
      $this->db->where_in('id', explode(',', $warehouseList[0]['client_id']));
    }
    $clientList = $this->db->get('tbl_clients')->result_array();
//    pre($clientList);
    //last_query();
//    } else {
//      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
//    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    //die;




    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_detailed_c_l_w_d_sd", $this->global, $data, NULL);
  }

//  function get_date_ranged_report_excel_new_detailed() {
//    $this->load->library('excel');
//    $this->load->helper('report');
//    if ($this->session->userdata('role') == '4') {
//      $department_id = $this->session->userdata('department_id');
//      $sub_department_id = $this->session->userdata('sub_department_id');
//    } else {
//      $shift = $this->input->post('shift');
//      $subdepartment = $this->input->post('subdepartment');
//      $departmentId = $this->input->post('departmentId');
//      $clientId = $this->input->post('clientId');
//      $organizationid = $this->input->post('warehouseId');
//      $locationId = $this->input->post('locationId');
//      if ($shift != '') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift();
//        die;
//      } elseif ($department_id != '' && $department_id != 'all') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_all();
//        die;
//      } elseif ($department_id != '' && $department_id != 'all') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d();
//        die;
//      } elseif ($department_id != '' && $department_id != 'all') {
//        $this->get_date_ranged_report_excel_new_detailed_c_l_w_d();
//        die;
//      }
//      //pre($this->input->post());
//      $this->get_date_ranged_report_excel_new_detailed_c_l_w_d();
//      die;
//    }
//  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //$filename = 'detailed_productivity_report_' . clientName(clientIdByLocationId(locationIdByOrgId($organization_id))) . '_' . locationName(locationIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client Name')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:G1')->setCellValue('B1', clientName(clientIdByLocationId(locationIdByOrgId($organization_id))))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Location')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:G2')->setCellValue('B2', locationName(locationIdByOrgId($organization_id)))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Warehouse')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:G3')->setCellValue('B3', orgName($organization_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:G4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:G5')->setCellValue('B5', subDeptName($sub_department_id))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date Range')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:G6')->setCellValue('B6', $fromDate . '_to_' . $toDate)->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Date')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B7', 'Superviser')->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C7', 'Total Challan')->getStyle('C5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D7', 'Total Boxes')->getStyle('D5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E7', 'Toatal Qty')->getStyle('E5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F7', 'Total SKU')->getStyle('F5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G7', 'Total Manpower')->getStyle('G5')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 8;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY date';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(superviserBySubDeptId($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALMANPOWER);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fEmp);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_shift() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    //locationName(locationIdByOrgId($organization_id));
    //pre($this->input->post());
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    //$filename = 'detailed_productivity_report_' . clientName(clientIdByLocationId(locationIdByOrgId($organization_id))) . '_' . locationName(locationIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    //$filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $date . '.xls';
    $filename = 'detailed_productivity_report.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    //pre($all_team_ids);
//    echo superviserBySubDeptId($sub_department_id);
//    echo "<br>" . locationName(locationIdByOrgId($organization_id));
//    echo "<br>" . orgName($organization_id);
//    echo "<br>" . clientName($client_id);
//    echo "<br>" . deptName($department_id);
//    echo "<br>" . subDeptName($sub_department_id);
//    echo "<br>" . superviserBySubDeptId($sub_department_id);
//    echo "<br>" . shiftName($shift_id);
//    die;
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', subDeptName($sub_department_id))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Supervisor')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', superviserBySubDeptId($sub_department_id))->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Shift')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', shiftName($shift_id))->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Report Type')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B8:O8')->setCellValue('B8', ($shift_id && $shift_id != 'all') ? shiftName($shift_id) . "-Shift Manpower Report" : $shift_id . "-Shift Manpower Report")->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A9', 'Date Range')->getStyle('A9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B9:O9')->setCellValue('B9', $date)->getStyle('B9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A10', 'Report Generated Date & Time')->getStyle('A11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B10:O10')->setCellValue('B10', date("Y-m-d H:i:s"))->getStyle('B10')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A11', 'Employee Name')->getStyle('A11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B11', 'Emp Code')->getStyle('B11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C11', 'Total Benchmark')->getStyle('C11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D11', 'Benchmark Unit (UOM)')->getStyle('D11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E11', 'Challan')->getStyle('E11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F11', 'Boxes')->getStyle('F11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G11', 'Qty')->getStyle('G11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H11', 'SKU')->getStyle('H11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I11', 'KG')->getStyle('I11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J11', 'CFC')->getStyle('J11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K11', 'Bins')->getStyle('K11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L11', 'Pallet')->getStyle('L11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M11', 'Time')->getStyle('M11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N11', 'Productivity')->getStyle('N11')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O11', '%age Achievement')->getStyle('O11')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    //pre($all_team_ids);
    if (!empty($all_team_ids)) {
      $excelrow = 12;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY employee_id';
//      die;

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      //last_query();
      //pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
//$this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $challan['employee_id']);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $challan['challans']);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $challan['A']);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $challan['B']);
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['C']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, "0");
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, "0");
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, "0");
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, "0");
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $challan['time']);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, "0");
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, "0");
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, ($total / 3600) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_c_l_w_d_sd_all() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
    }
    //$fromDate = $this->input->post('from_date');
    //$toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    //$filename = 'detailed_productivity_report_' . clientName(clientIdByLocationId(locationIdByOrgId($organization_id))) . '_' . locationName(locationIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $date . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client Name')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:G1')->setCellValue('B1', clientName(clientIdByLocationId(locationIdByOrgId($organization_id))))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Location')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:G2')->setCellValue('B2', locationName(locationIdByOrgId($organization_id)))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Warehouse')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:G3')->setCellValue('B3', orgName($organization_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:G4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    //$this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department')->getStyle('A5')->getFont()->setBold(true);
    //$this->excel->getActiveSheet()->mergeCells('B5:G5')->setCellValue('B5', subDeptName($sub_department_id))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Date')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:G5')->setCellValue('B5', $date)->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Sub Dept')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B6', 'Superviser')->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C6', 'Total Challan')->getStyle('C5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D6', 'Total Boxes')->getStyle('D5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E6', 'Toatal Qty')->getStyle('E5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F6', 'Total SKU')->getStyle('F5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G6', 'Total Manpower')->getStyle('G5')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 7;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      $groupBY = ' GROUP BY sub_dept_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date =\'' . $this->input->post('date') . '\'  ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          //$this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(subDeptName($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(superviserBySubDeptId($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALMANPOWER);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fEmp);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function manpower_traking_report_view() {
    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')
//              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
          ->where('tbl_location.isDeleted', '0')
          ->group_by('tbl_location.loc_id')
          ->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')
//                      ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
//                      ->where_in('loc_id', $this->session->userdata('location_id'))
              ->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
//                      ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '4'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['1'])) {
      $warehouseList = $this->db->where('loc_id', $locationId)->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
//      $warehouseList = $this->db->where('loc_id', $locationId)->where('isDeleted', '0')->get('tbl_organization')->result_array();
    }
    //last_query();
    //pre($warehouseList);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
//    if ($this->role == 10) {
//      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
//      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
    if (isset($warehouseList[0]['client_id'])) {
      $this->db->where_in('id', explode(',', $warehouseList[0]['client_id']));
    }
    $clientList = $this->db->get('tbl_clients')->result_array();
//    pre($clientList);
    //last_query();
//    } else {
//      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
//    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    //die;




    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_traking_report", $this->global, $data, NULL);
  }

  function get_manpower_tracking_report() {
    // pre($this->input->post());
    $department_id = $this->input->post('departmentId');
    $sub_department_id = $this->input->post('subdepartment');
    $client_id = $this->input->post('clientId');
    $location_id = $this->input->post('locationId');
    $organization_id = $this->input->post('warehouseId');
    $emp_check = $this->input->post('emp_check');
    if (isset($emp_check) && !empty($emp_check)) {
      $this->get_manpower_tracking_report_detailed();
      die;
    } else {
      $this->download_today_report();
      die;
    }
  }

  public function download_today_report() {
    $departmentId = $this->input->post('departmentId');
    $subDepartmentId = $this->input->post('subdepartment');
    $clientId = $this->input->post('clientId');
    $locId = $this->input->post('locationId');
    $orgId = $this->input->post('warehouseId');
    $client_list = $this->db->from('tbl_clients')->get()->result_array();
    $currentStatus = "'1'";
    if ($departmentId != '') {
      $this->db->where('tbl_manpower_team_performance.dept_id', $departmentId);
    }
    if ($subDepartmentId != '') {
      $this->db->where('tbl_manpower_team_performance.sub_dept_id', $subDepartmentId);
    }
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->where('date', date('Y-m-d'));
    $this->db->group_by('employee_id');
    $all_team_employees_list = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_employees_list);
    if ($totalcount == '0') {
      $this->session->set_flashdata('success', 'Data Not Found with your Search.');
      redirect('manpower-traking-report-view');
    }
    $filename = 'manpower_tracking_report_' . locationName(locationIdByClientId(clientIdByOrgId($orgId))) . '_' . clientName(clientIdByOrgId($orgId)) . '_' . orgName($orgId) . '_' . deptName($departmentId) . '_' . subDeptName($subDepartmentId) . '_' . date('d/m/Y') . '.xls';
    $data['total_challans'] = 0;
    $data['total_boxes'] = 0;
    $data['total_qty'] = 0;
    $data['total_sku'] = 0;
    $data['all_employees_data'] = array();
    $index_counter = 0;
    $empIdList = array();
    foreach ($all_team_employees_list as $employee) {
      if (!empty($empIdList) && in_array($employee->employee_id, $empIdList)) {
        continue;
      }
      $empIdList[] = $employee->employee_id;
      $data['all_employees_data'][$index_counter]['employee_name'] = $this->db->select('name')->from('tbl_users')->where('userId', $employee->employee_id)->get()->row()->name;
      $data['all_employees_data'][$index_counter]['supervisor'] = $this->db->select('name')->from('tbl_users')->where('department_id', $employee->dept_id)->where('sub_department_id', $employee->sub_dept_id)->where('roleId', '4')->get()->row()->name;
      $data['all_employees_data'][$index_counter]['dept_name'] = deptName($employee->dept_id);
      $data['all_employees_data'][$index_counter]['org_name'] = orgName($employee->org);
      $data['all_employees_data'][$index_counter]['sub_dept'] = $employee->sub_dept_id;
      $total_time_query = $this->db->select('time')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
      if ($total_time_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_time'] = $total_time_query->row()->time;
      } else {
        $data['all_employees_data'][$index_counter]['total_time'] = '00:00';
      }
      $total_challans_query = $this->db->select('challans')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
      if ($total_challans_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_challans'] = $total_challans_query->row()->challans;
      } else {
        $data['all_employees_data'][$index_counter]['total_challans'] = 0;
      }
      $total_boxes_query = $this->db->select('A')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
      if ($total_boxes_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_boxes'] = $total_boxes_query->row()->A;
      } else {
        $data['all_employees_data'][$index_counter]['total_boxes'] = 0;
      }
      $total_qty_query = $this->db->select('B')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
      if ($total_qty_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_qty'] = $total_qty_query->row()->B;
      } else {
        $data['all_employees_data'][$index_counter]['total_qty'] = 0;
      }
      $total_sku_query = $this->db->select('C')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
      if ($total_sku_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_sku'] = $total_sku_query->row()->C;
      } else {
        $data['all_employees_data'][$index_counter]['total_sku'] = 0;
      }
      $chck_absent_query = $this->db->select('absent')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get();
      if ($chck_absent_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['absent'] = $chck_absent_query->row()->absent;
      } else {
        $data['all_employees_data'][$index_counter]['absent'] = 0;
      }
      $time = array();
      $time[] = $this->db->select('time')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->time;
      $time[] = $data['total_time'];
      $data['total_time'] = $this->AddPlayTime($time);
      $data['total_challans'] = $data['total_challans'] + $this->db->select('challans')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->challans;
      $data['total_boxes'] = $data['total_boxes'] + $this->db->select('A')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->A;
      $data['total_qty'] = $data['total_qty'] + $this->db->select('B')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->B;
      $data['total_sku'] = $data['total_sku'] + $this->db->select('C')->from('tbl_manpower_team_performance')->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->C;
      $index_counter++;
    }
    $this->load->library('excel');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Today Report');

    $this->excel->getActiveSheet()->setCellValue('A1', 'Client Name')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:F1')->setCellValue('B1', clientName(clientIdByLocationId(locationIdByOrgId($orgId))))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Location')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:F2')->setCellValue('B2', locationName(locationIdByOrgId($orgId)))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Warehouse')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:F3')->setCellValue('B3', orgName($orgId))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department Name')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:F4')->setCellValue('B4', deptName($departmentId))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department Name')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:F5')->setCellValue('B5', subDeptName($subDepartmentId))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Superviser')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:F6')->setCellValue('B6', superviserBySubDeptId($subDepartmentId))->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Shift')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:F7')->setCellValue('B7', shiftNameBySubDeptId($subDepartmentId))->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Date Range')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B8:F8')->setCellValue('B8', date('d/m/Y'))->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A9', 'Employee Name')->getStyle('A9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B9', 'Challan')->getStyle('B9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C9', 'Boxes')->getStyle('C9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D9', 'Qty')->getStyle('D9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E9', 'SKU')->getStyle('E9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F9', 'Time')->getStyle('F9')->getFont()->setBold(true);
    if (isset($data['all_employees_data']) && !empty($data['all_employees_data'])) {
      $excelrow = 10;
      foreach ($data['all_employees_data'] as $key => $emp) {
        if (isset($emp['absent']) && $emp['absent'] == 1) {
          $emp['total_challans'] = 'A';
          $emp['total_boxes'] = 'A';
          $emp['total_qty'] = 'A';
          $emp['total_sku'] = 'A';
          $emp['total_time'] = 'A';
        }
        $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst($emp['employee_name']));
        $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $emp['total_challans']);
        $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $emp['total_boxes']);
        $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $emp['total_qty']);
        $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $emp['total_sku']);
        $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $emp['total_time']);
        $excelrow++;
      }
      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, $data['total_challans']);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $data['total_boxes']);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $data['total_qty']);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $data['total_sku']);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $data['total_time']);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    //save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
    //if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    //force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    exit;
  }

  function get_manpower_tracking_report_detailed() {
//    echo empCodeByEmpId($this->input->post('emp_name'));
//    die;
//    pre($this->input->post());
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $emp_name = $this->input->post('emp_name');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    //echo $filename = 'detailed_productivity_report_' . locationName(locationIdByClientId(clientIdByOrgId($organization_id))) . '_' . clientName(clientIdByOrgId($organization_id)) . '_' . orgName($organization_id) . '_' . deptName($department_id) . '_' . subDeptName($sub_department_id) . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $filename = 'detailed_productivity_report.xls';
    //die;
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();

//    echo empCodeByEmpId($this->input->post('emp_name'));
//    die;
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Employee Name')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:T1')->setCellValue('B1', empNameById($this->input->post('emp_name')))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Employee Code')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:T2')->setCellValue('B2', empCodeByEmpId($this->input->post('emp_name')))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Report Type')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:T3')->setCellValue('B3', empNameById($this->input->post('emp_name')) . "'s Productivity Report")->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Date Range')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:T4')->setCellValue('B4', $fromDate . '-to-' . $toDate)->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Report Generated Date & Time')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:T5')->setCellValue('B5', date("Y-m-d H:i:s"))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B6', 'Shift')->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C6', 'Sub Department')->getStyle('C6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D6', 'Department')->getStyle('D6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E6', 'Client')->getStyle('E6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F6', 'Warehouse')->getStyle('F6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G6', 'Location')->getStyle('G6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H6', 'Total Benchmark')->getStyle('H6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I6', 'Benchmark Unit (UOM)')->getStyle('I6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J6', 'Challan')->getStyle('J6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K6', 'Boxes')->getStyle('K6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L6', 'Qty')->getStyle('L6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M6', 'SKU')->getStyle('M6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N6', 'KG')->getStyle('N6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O6', 'CFC')->getStyle('O6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P6', 'Bins')->getStyle('P6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q6', 'Pallet')->getStyle('Q6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R6', 'Line')->getStyle('Q6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('S6', 'Time')->getStyle('R6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('T6', 'Productivity')->getStyle('S6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('U6', '% age Achievement')->getStyle('T6')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 7;
      $where = ' ';
      $select = ' ';
      $groupBY = '  GROUP BY location';
      if ($location_id != '' && $location_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
        $groupBY = ' GROUP BY location';
      } elseif ($location_id == 'all') {
        $groupBY = ' GROUP BY location';
      }
      if ($client_id != '' && $client_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
        $groupBY = ' GROUP BY client';
      } elseif ($client_id == 'all') {
        $groupBY = ' GROUP BY client';
      }

      if ($organization_id != '' && $organization_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
        $groupBY = ' GROUP BY org';
      } elseif ($organization_id == 'all') {
        $groupBY = ' GROUP BY org';
      }
      if ($department_id != '' && $department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
        $groupBY = ' GROUP BY dept_id';
      } elseif ($department_id == 'all') {
        $groupBY = ' GROUP BY dept_id';
      }
      if ($sub_department_id != '' && $sub_department_id != 'all') {
        $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
        $groupBY = ' GROUP BY sub_dept_id';
      } elseif ($sub_department_id == 'all') {
        $groupBY = ' GROUP BY sub_dept_id';
      }
      if ($emp_name != '' && $emp_name != 'all') {
        $where .= ' AND tbl_manpower_team_performance.employee_id = ' . $emp_name;
        $groupBY = ' GROUP BY $emp_name';
      } elseif ($emp_name == 'all') {
        $groupBY = ' GROUP BY employee_id';
      }
      $groupBY = ' GROUP BY date';

      $total_challans = $this->db->query('SELECT *,TIME_TO_SEC(time) as total_sec_worked,A as boxes,B as qty,C as sku, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//      echo last_query();
//      pre($total_challans);
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('manpower-traking-report-view');
      }
      $total_banchmark = $this->db->query('SELECT IFNULL(SUM(banchmark), 0) AS total_banchmark,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_line = $this->db->query('SELECT IFNULL(SUM(line), 0) AS total_line,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
//      pre($total_challans);
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
//          pre($challan);
          $shiftMngt = getShiftMngtBySupervisor($challan['superviser_id'], $challan['dept_id'], $challan['sub_dept_id']);
          $totalSec = (int) round($shiftMngt['total_sec_to_work'], '2');
          $uomKey = $challan['uom'];
          $AchivementPer = ((($challan[$uomKey] / 1) * 100 * $totalSec) / (($challan['banchmark']) * (($challan['total_sec_worked'])) . ' %'));
          $AchivementPer = (integer) (round($AchivementPer)) ? round($AchivementPer) : '0';
          $totalArray = [];
//          pre($challan['total_challans']);
          $fBanchmark += $totalArray['benchmark'] = $TOTALBANCHMARK = isset($total_banchmark[$key1]['total_banchmark']) ? $total_banchmark[$key1]['total_banchmark'] : 0;
          $fChallan += $totalArray['challans'] = $TCHALLAN = $challan['total_challans'];
          $fBoxes += $totalArray['boxes'] = $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $totalArray['qty'] = $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $totalArray['sku'] = $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fkg += $totalArray['kg'] = $TOTALKG = isset($total_kg[$key1]['total_kg']) ? $total_kg[$key1]['total_kg'] : 0;
          $fcfc += $totalArray['cfc'] = $TOTALCFC = isset($total_cfc[$key1]['total_cfc']) ? $total_cfc[$key1]['total_cfc'] : 0;
          $fbins += $totalArray['bins'] = $TOTALBINS = isset($total_bins[$key1]['total_bins']) ? $total_bins[$key1]['total_bins'] : 0;
          $fline += $totalArray['line'] = $TOTALLINE = isset($total_line[$key1]['total_line']) ? $total_line[$key1]['total_line'] : 0;
          $fpallet += $totalArray['pallet'] = $TOTALPALLET = isset($total_pallet[$key1]['total_pallet']) ? $total_pallet[$key1]['total_pallet'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $fTotalTime += $TOTALTIMEe = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;
//          pre($totalArray);
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, shiftName($challan['shift']));
          $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, ucfirst(subDeptName($challan['sub_dept_id'])));
          $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, deptName($challan['dept_id']));
          $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, clientName($challan['client']));
          $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, orgName($challan['org']));
          $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, locationName($challan['location']));
          $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $challan['banchmark']);
          $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $challan['uom']);
          $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TCHALLAN);
          $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALBOXES);
          $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $TOTALQTY);
          $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $TOTALSKU);
          $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $TOTALKG);
          $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $TOTALCFC);
          $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $TOTALBINS);
          $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $TOTALPALLET);
          $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $TOTALLINE);
          $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $total_time[$key1]['total_time']);
          $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, ($challan[$uomKey] / 1));
          $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, abs($AchivementPer));
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
          $excelrow++;

          $element = $total_time[$key1]['total_time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];
        }
      }
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, 'Total : ')->getStyle('I' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function AddPlayTime($times) {
    $minutes = 0;

    foreach ($times as $time) {
      list($hour, $minute) = explode(':', $time);
      $minutes += $hour * 60;
      $minutes += $minute;
    }

    $hours = floor($minutes / 60);
    $minutes -= $hours * 60;

// returns the time already formatted
    return sprintf('%02d:%02d', $hours, $minutes);
  }

  function getdetailsPreview() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    if ($this->input->post("roleId")) {
      $roleId = intval($this->input->post("roleId"));
    }
//    pre($this->input->post());

    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');

    $empsearchText = $this->input->post('emp_id');
    $empId = '';
    $empCode = '';
    $empName = '';
    if ($empsearchText != '') {
      $emparray = explode('_', $empsearchText);
      $empId = isset($emparray[0]) ? $emparray[0] : '';
      $empCode = isset($emparray[1]) ? $emparray[1] : '';
      $empName = isset($emparray[2]) ? $emparray[2] : '';
    }

    if ($search != '') {
//$emparray = explode('_', $empsearchText);
      $empId = isset($search) ? $search : '';
      $empCode = isset($search) ? $search : '';
      $empName = isset($search) ? $search : '';
    }

    if ($this->session->userdata('role') == '4') {
//      pre($this->input->post());
      $location_id = $this->input->post('location');
      $organization_id = $this->input->post('organization');
      $client_id = $this->input->post('client');
      $department_id = $this->input->post('department');
      $sub_department_id = $this->input->post('subdepartment');
    } else {
      $location_id = $this->input->post('location');
      $organization_id = $this->input->post('organization');
      $client_id = $this->input->post('client');
      $department_id = $this->input->post('department');
      $sub_department_id = $this->input->post('subdepartment');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY client';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
//      pre($this->session->userdata('role'));
    if ($this->session->userdata('role') == '4') {
      $where .= ' AND tbl_manpower_team_performance.superviser_id = ' . $this->session->userdata('userId');
    }
//      echo $where;
//      die;
    $groupBY = ' GROUP BY date,client,dept_id,sub_dept_id,tbl_manpower_team_performance.shift,employee_code,employee_id,id';
    $queryChallan = 'SELECT tbl_manpower_team_performance.*,TIME_TO_SEC(time) as total_sec_worked,A as boxes,B as qty,C as sku, '
        . 'IFNULL(SUM(challans), 0) AS total_challans,'
        . 'IFNULL(SUM(A), 0) AS total_boxes,'
        . 'IFNULL(SUM(B), 0) AS total_qty,'
        . 'IFNULL(SUM(C), 0) AS total_sku,'
        . 'IFNULL(SUM(kg), 0) AS total_kg,'
        . 'IFNULL(SUM(cfc), 0) AS total_cfc,'
        . 'IFNULL(SUM(bins), 0) AS total_bins,'
        . 'IFNULL(SUM(pallet), 0) AS total_pallet,'
        . 'IFNULL(SUM(line), 0) AS total_line,'
        . 'IFNULL(COUNT(absent),0) AS manpower,'
        . 'IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,'
        . 'date ' . $select . ' FROM tbl_manpower_team_performance left join tbl_users on tbl_users.userId = tbl_manpower_team_performance.employee_id WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY;
    $total_challans = $this->db->query($queryChallan)->result_array();
    $totalcount = count($total_challans);
//    last_query();
//    $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_line = $this->db->query('SELECT IFNULL(SUM(line), 0) AS total_line,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
    $totalrows = $totalcount;

    if ($this->session->userdata('role') == '4') {
//      pre($this->input->post());
      $location_id = $this->input->post('location');
      $organization_id = $this->input->post('organization');
      $client_id = $this->input->post('client');
      $department_id = $this->input->post('department');
      $sub_department_id = $this->input->post('subdepartment');
    } else {
      $location_id = $this->input->post('location');
      $organization_id = $this->input->post('organization');
      $client_id = $this->input->post('client');
      $department_id = $this->input->post('department');
      $sub_department_id = $this->input->post('subdepartment');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY client';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
//      pre($this->session->userdata('role'));
    if ($this->session->userdata('role') == '4') {
      $where .= ' AND tbl_manpower_team_performance.superviser_id = ' . $this->session->userdata('userId');
    }
//      echo $where;
//      die;
    // $groupBY = ' GROUP BY date,client,dept_id,sub_dept_id,shift,employee_code,employee_id,id';
//    $total_challans = $results = $this->db->query('SELECT *,TIME_TO_SEC(time) as total_sec_worked,A as boxes,B as qty,C as sku, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY . ' limit ' . $start . ' ,' . $length)->result_array();
    $groupBY = ' GROUP BY date,client,dept_id,sub_dept_id,tbl_manpower_team_performance.shift,employee_code,employee_id,id';
    $queryChallan = 'SELECT tbl_manpower_team_performance.*,TIME_TO_SEC(time) as total_sec_worked,A as boxes,B as qty,C as sku, '
        . 'IFNULL(SUM(challans), 0) AS total_challans,'
        . 'IFNULL(SUM(A), 0) AS total_boxes,'
        . 'IFNULL(SUM(B), 0) AS total_qty,'
        . 'IFNULL(SUM(C), 0) AS total_sku,'
        . 'IFNULL(SUM(kg), 0) AS total_kg,'
        . 'IFNULL(SUM(cfc), 0) AS total_cfc,'
        . 'IFNULL(SUM(bins), 0) AS total_bins,'
        . 'IFNULL(SUM(pallet), 0) AS total_pallet,'
        . 'IFNULL(SUM(line), 0) AS total_line,'
        . 'IFNULL(COUNT(absent),0) AS manpower,'
        . 'IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,'
        . 'date ' . $select . ' FROM tbl_manpower_team_performance left join tbl_users on tbl_users.userId = tbl_manpower_team_performance.employee_id WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY . ' limit ' . $start . ' ,' . $length;
    $total_challans = $this->db->query($queryChallan)->result_array();
//    last_query();
//    pre($total_challans);
//    $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_kg = $this->db->query('SELECT IFNULL(SUM(kg), 0) AS total_kg,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_cfc = $this->db->query('SELECT IFNULL(SUM(cfc), 0) AS total_cfc,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_bins = $this->db->query('SELECT IFNULL(SUM(bins), 0) AS total_bins,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_pallet = $this->db->query('SELECT IFNULL(SUM(pallet), 0) AS total_pallet,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_line = $this->db->query('SELECT IFNULL(SUM(line), 0) AS total_line,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
//    $totalrows = count($total_challans);
//    pre($total_challans);
    $data = [];
    if (!empty($total_challans)) {
      foreach ($total_challans as $key1 => $challan) {
        $shiftMngt = getShiftMngtBySupervisor($challan['superviser_id'], $challan['dept_id'], $challan['sub_dept_id']);
        $totalSec = (int) round($shiftMngt['total_sec_to_work'], '2');
        $uomKey = $challan['uom'];
        $AchivementPer = ((($challan[$uomKey] / 1) * 100 * $totalSec) / (($challan['banchmark']) * (($challan['total_sec_worked'])) . ' %'));
        $AchivementPer = (integer) (round($AchivementPer)) ? round($AchivementPer) : '0';
        $fChallan += $TCHALLAN = $challan['total_challans'];
        $fBoxes += $TOTALBOXES = $challan['total_boxes'];
        $fQty += $TOTALQTY = $challan['total_qty'];
        $fSku += $TOTALSKU = $challan['total_sku'];
        $fKG += $TOTALKG = $challan['total_kg'];
        $fCFC += $TOTALCFC = $challan['total_cfc'];
        $fBINS += $TOTALBINS = $challan['total_bins'];
        $fPALLET += $TOTALPALLET = $challan['total_pallet'];
        $fLINE += $TOTALLINE = $challan['total_line'];
        $fEmp += $TOTALMANPOWER = $challan['manpower'];
        $fTime += $TOTALTIME = $challan['total_time'];
//        pre($userinfo);

        $attr = array();
        $attr[] = date('d-m-Y', strtotime($challan['date']));
        $attr[] = locationName($challan['location']);
        $attr[] = clientName($challan['client']);
        $attr[] = orgName($challan['org']);
        $attr[] = deptName($challan['dept_id']);
        $attr[] = subDeptName($challan['sub_dept_id']);
        $attr[] = $challan['shift'];
        if ($challan['emp_type'] == 'Contractual') {
          $attr[] = $challan['co_emp_name'];
        } else {
          $attr[] = empNameById($challan['employee_id']) ? empNameById($challan['employee_id']) : $challan['co_emp_name'];
        }
        $attr[] = empCodeByEmpId($challan['employee_id']) ? empCodeByEmpId($challan['employee_id']) : ucfirst($challan['employee_code']);
        $attr[] = $challan['banchmark'];
        $attr[] = $challan['uom'];
        $attr[] = $TCHALLAN;
        $attr[] = $TOTALBOXES;
        $attr[] = $TOTALQTY;
        $attr[] = $TOTALSKU;
        $attr[] = $TOTALKG;
        $attr[] = $TOTALCFC;
        $attr[] = $TOTALBINS;
        $attr[] = $TOTALPALLET;
        $attr[] = $TOTALLINE;
        $attr[] = $TOTALTIME;
        $attr[] = ($challan[$uomKey] / 1);
        $attr[] = abs($AchivementPer);
        $attr[] = $challan['remark'];
        $attr[] = $challan['emp_type'];
        $data[] = $attr;
      }
    }
//    pre($data);

    $output = array(
      "draw" => $draw,
      "recordsTotal" => $totalrows,
      "recordsFiltered" => $totalrows,
      "data" => $data
    );
    echo json_encode($output);
    exit();
  }

}
