<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

/**
 * Class : Login (LoginController)
 * Login class to control to authenticate user credentials and starts user's session.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class Login extends CI_Controller {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('login_model');
    date_default_timezone_set('Asia/Kolkata');
  }

  /**
   * Index Page for this controller.
   */
  public function index() {
    $this->isLoggedIn();
  }

  /**
   * This function used to check the user is logged in or not
   */
  function isLoggedIn() {
    $isLoggedIn = $this->session->userdata('isLoggedIn');

    if (!isset($isLoggedIn) || $isLoggedIn != TRUE) {
      $this->load->view('login');
    } else {
      redirect('/dashboard');
    }
  }

  /**
   * This function used to logged in user
   */
  public function loginMe() {
    $this->load->library('form_validation');
    $this->form_validation->set_rules('email', 'Email', 'required|max_length[128]|trim');
    $this->form_validation->set_rules('password', 'Password', 'required|max_length[32]');
    if ($this->form_validation->run() == FALSE) {
      $this->index();
    } else {
      $email = strtolower($this->security->xss_clean($this->input->post('email')));
      $password = $this->input->post('password');
      $result = $this->login_model->loginMe($email, $password);
      if (!empty($result)) {
        $lastLogin = $this->login_model->lastLoginInfo($result->userId);
        $sessionArray = array(
            'userId' => $result->userId,
            'role' => $result->roleId,
            'shift' => $result->shift,
            'roleText' => $result->role,
            'email' => $result->email,
            'name' => $result->name,
            'lastLogin' => $lastLogin->createdDtm,
            'isLoggedIn' => TRUE,
            'avatar' => $result->avatar,
            'organization_id' => $result->organization_id,
            'client_id' => $result->client_id,
            'location_id' => $result->location,
            'department_id' => $result->department_id,
            'sub_department_id' => $result->sub_department_id,
            'reporting_manager' => $result->reporting_manager,
            'doj' => $result->doj
        );

        $this->session->set_userdata($sessionArray);
        unset($sessionArray['userId'], $sessionArray['isLoggedIn'], $sessionArray['lastLogin']);
        $loginInfo = array("userId" => $result->userId, "sessionData" => json_encode($sessionArray), "machineIp" => $_SERVER['REMOTE_ADDR'], "userAgent" => getBrowserAgent(), "agentString" => $this->agent->agent_string(), "platform" => $this->agent->platform());
        $this->login_model->lastLogin($loginInfo);
        redirect('/dashboard');
      } else {
        $this->session->set_flashdata('error', 'Email or password mismatch');
        $this->index();
      }
    }
  }

  /**
   * This function used to load forgot password view
   */
  public function forgotPassword() {
    $isLoggedIn = $this->session->userdata('isLoggedIn');

    if (!isset($isLoggedIn) || $isLoggedIn != TRUE) {
      $this->load->view('forgotPassword');
    } else {
      redirect('/dashboard');
    }
  }

  /**
   * This function used to generate reset password request link
   */
  function resetPasswordUser() {
    $status = '';

    $this->load->library('form_validation');

    $this->form_validation->set_rules('login_email', 'Email', 'trim|required|valid_email');

    if ($this->form_validation->run() == FALSE) {
      $this->forgotPassword();
    } else {
      $email = strtolower($this->security->xss_clean($this->input->post('login_email')));

      if ($this->login_model->checkEmailExist($email)) {
        $encoded_email = urlencode($email);

        $this->load->helper('string');
        $data['email'] = $email;
        $data['activation_id'] = random_string('alnum', 15);
        $data['createdDtm'] = date('Y-m-d H:i:s');
        $data['agent'] = getBrowserAgent();
        $data['client_ip'] = $this->input->ip_address();

        $save = $this->login_model->resetPasswordUser($data);

        if ($save) {
          $data1['reset_link'] = base_url() . "resetPasswordConfirmUser/" . $data['activation_id'] . "/" . $encoded_email;
          $userInfo = $this->login_model->getCustomerInfoByEmail($email);

          if (!empty($userInfo)) {
            $data1["name"] = $userInfo->name;
            $data1["email"] = $userInfo->email;
            $data1["message"] = "Reset Your Password";
          }

          $sendStatus = resetPasswordEmail($data1);

          if ($sendStatus) {
            $status = "send";
            setFlashData($status, "Reset password link sent successfully, please check mails.");
          } else {
            $status = "notsend";
            setFlashData($status, "Email has been failed, try again.");
          }
        } else {
          $status = 'unable';
          setFlashData($status, "It seems an error while sending your details, try again.");
        }
      } else {
        $status = 'invalid';
        setFlashData($status, "This email is not registered with us.");
      }
      redirect('/forgotPassword');
    }
  }

  /**
   * This function used to reset the password
   * @param string $activation_id : This is unique id
   * @param string $email : This is user email
   */
  function resetPasswordConfirmUser($activation_id, $email) {
    // Get email and activation code from URL values at index 3-4
    $email = urldecode($email);

    // Check activation id in database
    $is_correct = $this->login_model->checkActivationDetails($email, $activation_id);

    $data['email'] = $email;
    $data['activation_code'] = $activation_id;

    if ($is_correct == 1) {
      $this->load->view('newPassword', $data);
    } else {
      redirect('/login');
    }
  }

  function sendTicketNotificationEmail() {
    error_reporting(-1);
    $todaydate = date('Y-m-d');
    $yesterdaydate = date('Y-m-d', strtotime("-1 days"));

    $this->db->select("id,ticket_no,due_date,priority,status,Date_ADD(due_date, INTERVAL +1 day) AS 'next_date'");
    $this->db->where("status != '1'");
    $this->db->having("(due_date LIKE '%$todaydate%' OR next_date LIKE '%$todaydate%')");
    $ticketList = $this->db->get('tbl_tickets')->result_array();


    if (!empty($ticketList)) {
      foreach ($ticketList as $ticket) {
        $ticketNo = $ticket['ticket_no'];
        $this->db->select('GROUP_CONCAT(tbl_users.email) as userEmail');
        $this->db->where('ticket_no', $ticket['id']);
        $this->db->from('tbl_ticket_assign_user');
        $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user');
        $assignedUsers = $this->db->get()->row_array();
        if (!empty($assignedUsers)) {
          $sendUsers = isset($assignedUsers['userEmail']) ? $assignedUsers['userEmail'] : '';
          if ($sendUsers != '') {
            $attr = array();
            $attr['ticketId'] = $ticketNo;
            $attr['sendemail'] = $sendUsers;
            echo sendticketreminder($attr);
            echo '<br>';
          }
        }
      }
    }


    //$this->db->where()
  }

  /**
   * This function used to create new password for user
   */
  function createPasswordUser() {
    $status = '';
    $message = '';
    $email = strtolower($this->input->post("email"));
    $activation_id = $this->input->post("activation_code");

    $this->load->library('form_validation');

    $this->form_validation->set_rules('password', 'Password', 'required|max_length[20]');
    $this->form_validation->set_rules('cpassword', 'Confirm Password', 'trim|required|matches[password]|max_length[20]');

    if ($this->form_validation->run() == FALSE) {
      $this->resetPasswordConfirmUser($activation_id, urlencode($email));
    } else {
      $password = $this->input->post('password');
      $cpassword = $this->input->post('cpassword');

      // Check activation id in database
      $is_correct = $this->login_model->checkActivationDetails($email, $activation_id);

      if ($is_correct == 1) {
        $this->login_model->createPasswordUser($email, $password);

        $status = 'success';
        $message = 'Password reset successfully';
      } else {
        $status = 'error';
        $message = 'Password reset failed';
      }

      setFlashData($status, $message);

      redirect("/login");
    }
  }

}
