<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$crate_id = '';
$operation_name = '';
$userid = '';
$warehouse_id = '';

if (isset($data['crate_id'])) {
    $crate_id = trim($data['crate_id']);
} elseif (isset($_POST['crate_id'])) {
    $crate_id = trim($_POST['crate_id']);
}

if (isset($data['operation_name'])) {
    $operation_name = trim($data['operation_name']);
} elseif (isset($_POST['operation_name'])) {
    $operation_name = trim($_POST['operation_name']);
}

if (isset($data['user_id'])) {
    $userid = trim($data['user_id']);
} elseif (isset($_POST['user_id'])) {
    $userid = trim($_POST['user_id']);
}

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

$response = ['success' => false, 'message' => '', 'crate_id' => $crate_id];

if ($crate_id === '' || $operation_name === '' || $userid === '' || $warehouse_id === '') {
    $response['message'] = 'crate_id and operation_name and UserId and Warehouse Id are required';
    echo json_encode($response);
    exit;
}

$transaction_id = uniqid("TXN");

$crate_id = mysqli_real_escape_string($mycon, $crate_id);
$operation_name = mysqli_real_escape_string($mycon, $operation_name);
$transaction_id = mysqli_real_escape_string($mycon, $transaction_id);

$sql_check = "SELECT * FROM crate_registation_tbl WHERE crate_id = '$crate_id'";
$result = mysqli_query($mycon, $sql_check);

if ($result && mysqli_num_rows($result) > 0) {
    $sql_update = "UPDATE crate_registation_tbl SET operation = '$operation_name', transaction_id = '$transaction_id', transaction_datetime = NOW()  WHERE crate_id = '$crate_id'";

    if (mysqli_query($mycon, $sql_update)) {
        // INSERT history record
        $crate_row = mysqli_fetch_assoc($result);
        

        $sql_insert_history = "INSERT INTO crate_tracking_history (user_id, warehouse_id, crate_id, operation, transaction_id, transaction_date_time) VALUES ('$userid', '$warehouse_id', '$crate_id', '$operation_name', '$transaction_id', NOW())";
        mysqli_query($mycon, $sql_insert_history);

        $response['success'] = true;
        $response['message'] = 'Crate Updated Successfully';
        $response['transaction_id'] = $transaction_id;
        $response['operation_name'] = $operation_name;
    } else {
        $response['message'] = 'Error updating crate: ' . mysqli_error($mycon);
    }
} else {
    $response['message'] = 'Invalid Crate ID';
}

echo json_encode($response);
