<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$invoice_no = '';
$warehouse_id = '';
$page = 1;
$limit = 10;
$search = '';

if (isset($data['invoice_no'])) {
    $invoice_no = trim($data['invoice_no']);
} elseif (isset($_POST['invoice_no'])) {
    $invoice_no = trim($_POST['invoice_no']);
}

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

if (isset($data['page'])) {
    $page = max(1, intval($data['page']));
} elseif (isset($_POST['page'])) {
    $page = max(1, intval($_POST['page']));
}

if (isset($data['limit'])) {
    $limit = max(1, intval($data['limit']));
} elseif (isset($_POST['limit'])) {
    $limit = max(1, intval($_POST['limit']));
}

if (isset($data['search'])) {
    $search = trim($data['search']);
} elseif (isset($_POST['search'])) {
    $search = trim($_POST['search']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($invoice_no === '') {
    $response['message'] = 'Invoice no is required';
    echo json_encode($response);
    exit;
}

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is required';
    echo json_encode($response);
    exit;
}

$invoice_no = mysqli_real_escape_string($mycon, $invoice_no);
$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);
$search = mysqli_real_escape_string($mycon, $search);

// Pagination setup
$offset = ($page - 1) * $limit;

// Base query
$sql = "
    SELECT 
        invoice_no, 
        product_code, 
        invoice_qty, 
        qty,
        grn_rev_qty,
        no_of_boxes,
        no_of_boxes_issue,
        qty_issue_remark
    FROM upload_excel
    WHERE invoice_no = '$invoice_no'
";

// Apply search filter if not empty
if ($search !== '') {
    $sql .= " AND product_code LIKE '%$search%'";
}

// Add pagination
$sql .= " LIMIT $offset, $limit";

$result = mysqli_query($mycon, $sql);

// Count total records for pagination info
$count_sql = "
    SELECT COUNT(*) AS total
    FROM upload_excel
    WHERE invoice_no = '$invoice_no'
";
if ($search !== '') {
    $count_sql .= " AND product_code LIKE '%$search%'";
}
$count_result = mysqli_query($mycon, $count_sql);
$total = ($count_result && mysqli_num_rows($count_result) > 0) ? mysqli_fetch_assoc($count_result)['total'] : 0;

if ($result && mysqli_num_rows($result) > 0) {
    $products = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $products[] = [
            'Challan no' => $row['invoice_no'],
            'Product code' => $row['product_code'],
            'invoice_qty' => $row['invoice_qty'],
            'Total Challan Qty' => $row['qty'],
            'grn_rev_qty' => $row['grn_rev_qty'],
            'no_of_boxes' => $row['no_of_boxes'],
            'no_of_boxes_issue' => $row['no_of_boxes_issue'],
            'qty_issue_remark' => $row['qty_issue_remark']
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Data found';
    $response['data'] = $products;
    $response['pagination'] = [
        'page' => $page,
        'limit' => $limit,
        'total_records' => $total,
        'total_pages' => ceil($total / $limit)
    ];
} else {
    $response['message'] = 'No data found';
}

echo json_encode($response);
?>
