<?php
require_once '../init.php';
header('Content-Type: application/json');

// Read input (JSON + form-data support)
$data = json_decode(file_get_contents('php://input'), true);

$page  = 1;
$limit = 10;

if (isset($data['page'])) {
    $page = (int)$data['page'];
} elseif (isset($_POST['page'])) {
    $page = (int)$_POST['page'];
}

if (isset($data['limit'])) {
    $limit = (int)$data['limit'];
} elseif (isset($_POST['limit'])) {
    $limit = (int)$_POST['limit'];
}

// Default values if not set
$page  = $page > 0 ? $page : 1;
$limit = $limit > 0 ? $limit : 10;

// Calculate offset
$offset = ($page - 1) * $limit;

// Count total rows
$count_sql = "SELECT COUNT(*) as total FROM crate_registation_tbl";
$count_result = mysqli_query($mycon, $count_sql);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = $count_row['total'];
$total_pages = ceil($total_records / $limit);

// Fetch paginated rows
$sql = "SELECT crate_id, operation,transaction_datetime FROM crate_registation_tbl ORDER BY transaction_datetime DESC LIMIT $limit OFFSET $offset";
$result = mysqli_query($mycon, $sql);

$data = [];
if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }
}

// Response
$response = [
    'success' => true,
    'page' => $page,
    'limit' => $limit,
    'total_records' => $total_records,
    'total_pages' => $total_pages,
    'data' => $data
];

echo json_encode($response);
