<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$challan_no = '';
$warehouse_id = '';
$product_code = '';

if (isset($data['challan_no'])) {
    $challan_no = trim($data['challan_no']);
} elseif (isset($_POST['challan_no'])) {
    $challan_no = trim($_POST['challan_no']);
}

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

if (isset($data['product_code'])) {
    $product_code = trim($data['product_code']);
} elseif (isset($_POST['product_code'])) {
    $product_code = trim($_POST['product_code']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($challan_no === '' ) {
    $response['message'] = 'Challan no is required';
    echo json_encode($response);
    exit;
}

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is required';
    echo json_encode($response);
    exit;
}

if ($product_code === '') {
    $response['message'] = 'Product Code is required';
    echo json_encode($response);
    exit;
}

$challan_no = mysqli_real_escape_string($mycon, $challan_no);
$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

$sql_check = "SELECT id, product_code, qty, grn_rev_qty FROM upload_excel WHERE invoice_no = '$challan_no' AND product_code = '$product_code'";

$result = mysqli_query($mycon, $sql_check);

if ($result && mysqli_num_rows($result) > 0) {
    $products = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $products[] = [
            'UploadExcelId' => $row['id'],
            'Product code' => $row['product_code'],
            'Challan Product Qty' => $row['qty'],
            'GRN Qty' => $row['grn_rev_qty'],
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Challan Product Data Fetched Successfully';
    $response['data'] = $products;
} else {
    $response['message'] = 'Invalid Challan no or Product Code';
}

echo json_encode($response);
?>
