<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
	header('location: ../index.php');
}

function get_product_desc($product_code, $mycon)
{
	$sql_query = "SELECT `desc` FROM `material_master` WHERE part_no='" . $product_code . "'";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {

		while ($row = mysqli_fetch_assoc($result)) {
			$pro_desc = $row['desc'];
		}

		return $pro_desc;
	}
}

function GetPONumber($UploadExcelId, $mycon)
{
	$sql_query = "SELECT `lrno` FROM `upload_excel` WHERE id='" . $UploadExcelId . "'";
	$result = mysqli_query($mycon, $sql_query);
	if (mysqli_num_rows($result) > 0) {

		while ($row = mysqli_fetch_assoc($result)) {
			$lrno = $row['lrno'];
		}

		return $lrno;
	}
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
	$sql_query = "SELECT * FROM `quality_check` WHERE product_issue_status != 3 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by product_code DESC ";
	$result = mysqli_query($mycon, $sql_query);
	return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
	$sql_query = "SELECT * FROM `quality_check` WHERE product_issue_status != 3 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by product_code DESC";
	$result = mysqli_query($mycon, $sql_query);
	return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

	if (isset($_POST["page"])) {
		$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
		if (!is_numeric($page_number)) {
			die('Invalid page number!');
		} //incase of invalid page number
	} else {
		$page_number = 1; //if there's no page number, set it to 1
	}

	//Advance Search
	$startHour = "00:00:00";
	$endHour = "23:55:55";

	if ($_POST['item'] == 'product_code') {
		$srcitem = " AND product_code = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'issue_remark') {
		$srcitem = " AND issue_remark LIKE '%" . trim($_POST['colunmData']) . "%'";
	} else if ($_POST['item'] == 'batch_code') {
		$srcitem = " AND upload_excel_id = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'lot_no') {
		$srcitem = " AND lot_no = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'current_location') {
		$srcitem = " AND current_location = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'returned_from_process') {
		$srcitem = " AND returned_from_process = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'barcode') {
		$srcitem = " AND barcode = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'box_bar_code') {
		$srcitem = " AND box_bar_code = '" . trim($_POST['colunmData']) . "'";
	} else if ($_POST['item'] == 'all') {
		$srcitem = "";
	}

	if ($_POST['todt'] != '') {
		$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
	} else {
		$srcfrom = '';
	}

	//echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
?>
	<p class="details_table">
		<?php
		if ($_POST['item'] == '') {
			$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
			if ($is_defaultshowEntries > 20) {
				$defaultshowEntries = 20;
			} else {
				$defaultshowEntries = $is_defaultshowEntries;
			}
		?>
			<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
		<?php } else { ?>
			<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
		<?php } ?>
	</p>
	<div style="overflow: auto;">
		<table class="table table-striped table-bordered table-hover" id="sample_3">
			<thead>
				<tr class="poke">
					<th>LR <br /> /PO No. <br /> /Order No</th>
					<th>Invoice/Challan No.</th>
					<th>Product Code</th>
					<th>Product Description</th>
					<th>UOM</th>
					<th>Discrepancy <br /> Quantity</th>
					<th>Discrepancy Remark <br /> <span>(Defective Quantity in an Inspection)</span></th>
					<th>Batch Code</th>
					<th>GRN Number</th>
					<th>LOT No.</th>
					<th>Which location <br />has it found?</th>
					<th>Discrepancy <br /> Location</th>
					<th>QR Code/Barcode</th>
					<th>Expiry Date</th>
					<th>Mfg. Date</th>
					<th>Create On</th>
					<th>Packing Configuration</th>
					<th>Packed-In</th>
					<th>Loose Qty</th>
					<!--<th>Box QR Code/Barcode</th>-->
					<th style="padding: 0px 100px 0 50px !important;"> Action</th>
				</tr>
			</thead>
			<tbody>

				<?php $sql_query = "SELECT * FROM `quality_check` WHERE product_issue_status != 3 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC";

				$result123 = mysqli_query($mycon, $sql_query);
				$get_total_rows = mysqli_num_rows($result123);
				$total_pages = ceil($get_total_rows / $item_per_page);


				$page_position = (($page_number - 1) * $item_per_page);

				$sql_query_fetch = "SELECT * FROM `quality_check` WHERE product_issue_status != 3 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC LIMIT $page_position, $item_per_page";

				$result_fetch = mysqli_query($mycon, $sql_query_fetch);
				//echo '<br/>' . $sql_query_fetch;
				//echo '<br/>' . $sql_query;
				if (mysqli_num_rows($result_fetch) > 0) {
					while ($row = mysqli_fetch_assoc($result_fetch)) {

						$global_partdata = getmaterialBypartcode($row['product_code']);
						//partdesc,uom,category,moq,packing_configuration,packed_in
						//print_r($global_partdata);
						$packing_configuration = $global_partdata['packing_configuration'];
						$moq = $global_partdata['moq'];
						$packed_in = $global_partdata['packed_in'];
						$uom = $global_partdata['uom'];
						$x = $row['issue_qty'];
						$y = $moq;
						$loose  = fmod($x, $y);
						if ($loose == 0 || $loose == '') {
							$loose_qty = 0;
						} else {
							$loose_qty = $loose . " " . $uom;
						}
						$boxes  = ($x - $loose) / $y;
						$packedin_boxes = $boxes . " " . $packed_in;
						$prod_details = getmaterialBypartcode($row['product_code']);

						$desc = $prod_details['partdesc'];
						$uom = $prod_details['uom'];
						$lr_number = GetPONumber($row['upload_excel_id'], $mycon);
				?>
						<tr>
							<td> <?php echo $lr_number; ?> </td>
							<td> <?php echo $row['invoice_no']; ?> </td>
							<td> <?php echo $row['product_code']; ?> </td>
							<td> <?php echo $desc; ?> </td>
							<td> <?php echo $uom; ?> </td>
							<td> <?php echo $row['issue_qty']; ?> </td>
							<td> <?php echo $row['issue_remark']; ?> </td>
							<td> <?php echo $row['batchcode']; ?> </td>
							<td><?php echo $row['grn_id']; ?></td>
							<td> <?php echo $row['lot_no']; ?> </td>
							<td> <?php echo $row['found_location']; ?> </td>
							<td> <?php echo $row['current_location']; ?> </td>
							<td> <?php if ($row['barcode'] != '') {
										$barcode = $row['barcode'];
									} else {
										$barcode = '--';
									}
									echo $barcode; ?> </td>
							<td> <?php echo $row['expiry_date']; ?> </td>
							<td> <?php echo $row['mfg_date']; ?> </td>
							<td> <?php echo $row['created_on']; ?> </td>
							<td> <?php echo $packing_configuration; ?> </td>
							<td> <?php echo $packedin_boxes; ?> </td>
							<td> <?php echo $loose_qty; ?> </td>
							<!--<td> <?php if ($row['box_bar_code'] != '') {
											$box_bar_code = $row['box_bar_code'];
										} else {
											$box_bar_code = '--';
										}
										echo $box_bar_code; ?> </td>-->
							<td style="padding-top: 20px;"><?php if ($row['is_reserved'] == 0) { ?>
									<a href="discrepancy_product_movement.php?qc_item_id=<?php echo $row['id'] ?>&edit=1">
										<button class="btn btn-lg" style="padding: 5px 10px 0px; margin-top: -13px; background-color: #d6e8f1;">
											<span><i class="fa fa-play" style="font-size:18px; color:red; padding-bottom: 7px;"></i></span>
										</button>
									</a>

									<?php $pro_code = $row['product_code']; ?>

									<a href="reversal-quality-check-data.php?pro_code=<?php echo $pro_code; ?>"><span data-tooltip title="view" class="cursor"><i class="fa fa-eye" aria-hidden="true" style="font-size:20px;"></i></span></a>
									<span data-tooltip title="Upload Image" class="cursor"><i class="fa fa-image" data-toggle="modal" data-target="#myModal100" onclick="set_refference('<?php echo $row['id'] ?>')" aria-hidden="true" style="font-size:30px;"></i></span>

									<span data-tooltip title="Preview Image" class="cursor"><a href="disp_descrepancy_product_images_all.php?ref_id=<?php echo $row['id'] ?>&process_name=descrepancy_product" target="_blank"><i class="fa fa-film" aria-hidden="true" style="font-size:30px;"></i></a></span>
								<?php
															} else {
															} ?>
							</td>
						</tr>

					<?php
					}
				} else {
					?>
					<tr>
						<td><?php echo 'No Record Found'; ?></td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
	<div align="center">
		<?php
		/* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
		echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
		?>
	</div>
<?php
}
?>
</div>