<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}

function get_sales_dispatch_base($id, $mycon) {
   $total_rows = 0;
   $sql_query = "SELECT * FROM packed_quantity_data WHERE dispatched_auto_id='" . $id . "' group by order_id";
   $result = mysqli_query($mycon, $sql_query);
   $total_rows = mysqli_num_rows($result);
  return $total_rows;
}

function get_invoices_dispatch_base($id, $mycon) {
   $total_rows = 0;
   $sql_query = "SELECT om.invoice_number FROM packed_quantity_data pqd join order_management om on om.order_id=pqd.order_id WHERE pqd.dispatched_auto_id='" . $id . "'  AND om.is_plan=0  AND om.order_status != 1	AND om.order_type != 1 group by om.invoice_number";
   $result = mysqli_query($mycon, $sql_query);
   $total_rows = mysqli_num_rows($result);
  return $total_rows;
}

function get_sales_orders_dispatch_base($id, $mycon) {
  $ref_num = array();
  $sql_query = "SELECT om.ref_number FROM packed_quantity_data pqd join order_management om on om.order_id=pqd.order_id WHERE pqd.dispatched_auto_id='" . $id . "' AND om.is_plan=0  AND om.order_status != 1	 AND om.order_type != 1 group by om.ref_number";


  $result = mysqli_query($mycon, $sql_query);
  $total_rows = mysqli_num_rows($result);
  if (mysqli_num_rows($result) > 0) {

	while ($row = mysqli_fetch_assoc($result)) {
	  $ref_num[] = $row['ref_number'];
	}
  }
  $ref_numbers = implode(", ", $ref_num);
  return $ref_numbers;
}

function get_invoice_number_dispatch_base($id, $mycon) {
  $invoice_number = array();
  $sql_query = "SELECT om.invoice_number FROM packed_quantity_data pqd join order_management om on om.order_id=pqd.order_id WHERE pqd.dispatched_auto_id='" . $id . "' AND om.is_plan=0  AND om.order_status != 1 AND om.order_type != 1 group by om.invoice_number";


  $result = mysqli_query($mycon, $sql_query);
  $total_rows = mysqli_num_rows($result);
  if (mysqli_num_rows($result) > 0) {

	while ($row = mysqli_fetch_assoc($result)) {
	  $invoice_number[] = $row['invoice_number'];
	}
  }
  $invoice_numbers = implode(", ", $invoice_number);
  return $invoice_numbers;
}

function get_total_customer_dispatch_base($dispatched_auto_id, $mycon) {
  $sql_query = "SELECT pqd.order_id, om.customer_code FROM `packed_quantity_data` pqd, `order_management` om WHERE om.order_id = pqd.order_id AND pqd.dispatched_auto_id='" . $dispatched_auto_id . "' GROUP BY pqd.order_id, om.customer_code";
  $result = mysqli_query($mycon, $sql_query);
  $total_rows = mysqli_num_rows($result);
  
  return $total_rows;
}

function get_total_boxes_dispatch_base($id, $mycon) {
  $sql_query = "SELECT * FROM `packed_quantity_data` WHERE dispatched_auto_id='" . $id . "'  GROUP BY outward_packing_box_id ";
  $result = mysqli_query($mycon, $sql_query);
  $total_rows = mysqli_num_rows($result);
  return $total_rows;
}

function get_total_qty_dispatch_base($id, $mycon) {
  $sql_query = "SELECT SUM(picked_qt) AS total_dispatched_qty FROM `packed_quantity_data` WHERE dispatched_auto_id='" . $id . "'  ";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {

	while ($row = mysqli_fetch_assoc($result)) {
	  $dispatched_qty = $row['total_dispatched_qty'];
	}
  }
  return $dispatched_qty;
}

function get_total_lr_dispatch_base($id, $mycon) {
  $sql_query = "SELECT * FROM `packed_quantity_data` WHERE dispatched_auto_id='" . $id . "' GROUP BY lr_number_out ";
  $result = mysqli_query($mycon, $sql_query);
  $total_rows = mysqli_num_rows($result);
  return $total_rows;
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM `dispatch_log` WHERE 1=1 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM `dispatch_log` WHERE 1=1 " . $role_item . "";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

  if (isset($_POST["page"])) {
	$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
	if (!is_numeric($page_number)) {
	  die('Invalid page number!');
	} //incase of invalid page number
  } else {
	$page_number = 1; //if there's no page number, set it to 1
  }

//Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";

  if ($_POST['item'] == 'dispatch_id') {
	$srcitem = " AND id = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'vehicle_number') {
	$srcitem = " AND vehicle_number = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'transporter_name') {
	$srcitem = " AND transporter_name LIKE '%" . trim($_POST['colunmData']) . "%'";
  } else if ($_POST['item'] == 'all') {
	$srcitem = "";
  }

  if ($_POST['todt'] != '') {
	$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
  } else {
	$srcfrom = '';
  }
//Fetch data from role wised
//  if ($userdata['role'] == '2' || $userdata['role'] == '3') {
//	$user_location = $userdata['org_id'];
//	$user_client = $userdata['client_id'];
//	$user_org_id = get_organization_id($mycon, $user_client, $user_location);
//	$role_item = " AND tu.organization_id IN (" . $user_org_id . ")";
//	$loc_item = " AND loc_code = '" . $user_location . "' AND cust_code IN (" . $client_ids . ")";
//  } else {
//	$role_item = '';
//	$loc_item = '';
//	$user_org_id = '';
//  }

// echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
  ?>
  <p class="details_table">
	  <?php
	  if ($_POST['item'] == '') {
		$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
		if ($is_defaultshowEntries > 20) {
		  $defaultshowEntries = 20;
		} else {
		  $defaultshowEntries = $is_defaultshowEntries;
		}
		?>
		<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
	  <?php } else { ?>
		<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
	  <?php } ?>
  </p>
  <table class="table table-striped table-bordered table-hover" id="sample_3">
  	<thead>
  		<tr >
  			<th>Dispatch Id</th>
  			<th>Vehicle Number</th>
  			<th>Transporter Name</th>
  			<th>Total<br /> LRs</th>
			<th>Total <br />Invoices</th>
			<th>Sale <br />Delivery <br /> Number</th>
  			<th>Invoice / Challan Number</th>
  			
  			<!-- <th>Total <br />Boxes</th> -->
  			<th>Total <br />Dispatch <br />Qty</th>
  			<th>Total <br />Customers</th>
			<th>Total <br />Sale <br />Delivery <br />Orders</th>
			
			<th>Dispatch <br />Start Date</th>
  			<th>Dispatch <br />End Date</th>
  			<th>Status</th>
  			<th style="padding: 0px 45px 0 45px !important;">Action</th>
  		</tr>

  	</thead>
  	<tbody>

		  <?php
		  //get total number of records from database for pagination
		  $i = 1;
		  $sql_query = "SELECT * FROM `dispatch_log` WHERE 1=1 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC";

		  $result123 = mysqli_query($mycon, $sql_query);
		  $get_total_rows = mysqli_num_rows($result123);
		  $total_pages = ceil($get_total_rows / $item_per_page);


//get starting position to fetch the records
		  $page_position = (($page_number - 1) * $item_per_page);

		  $sql_query_fetch = "SELECT * FROM `dispatch_log` WHERE 1=1 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC LIMIT $page_position, $item_per_page";

		  $result_fetch = mysqli_query($mycon, $sql_query_fetch);
		  //echo '<br/>' . $sql_query_fetch;
		  //echo '<br/>' . $sql_query;
		 if (mysqli_num_rows($result_fetch) > 0) {
			while ($row = mysqli_fetch_assoc($result_fetch)) {
			//echo "<pre>"; print_r($row);
			  $total_lr_dispatch_base = get_total_lr_dispatch_base($row['id'], $mycon);
			  $total_boxes_dispatch_base = get_total_boxes_dispatch_base($row['id'], $mycon);
			  $total_qty = get_total_qty_dispatch_base($row['id'], $mycon);
			  $total_customer = get_total_customer_dispatch_base($row['id'], $mycon);
			  $get_ivoice = get_invoice_number_dispatch_base($row['id'], $mycon);
			  $sales_orders = get_sales_orders_dispatch_base($row['id'], $mycon);
			  $total_sales_orders = get_sales_dispatch_base($row['id'], $mycon);
			  $total_invoices = get_invoices_dispatch_base($row['id'], $mycon);
			  $iddd = $row['id'];
			  if ($total_qty != 0) { $edit = 1; } else { $edit = 0; }
			  ?>
	  		  <tr>
	  			<td><?php echo $row['id']; ?></td>
	  			<td><?php echo $row['vehicle_number']; ?></td>
	  			<td><?php echo $row['transporter_name']; ?></td>
	  			<td><?php echo $total_lr_dispatch_base; ?></td>
				<td><?php echo $total_invoices; ?></td>
				<td><?php echo $sales_orders; ?></td>
	  			<td><?php echo $get_ivoice; ?></td>
	  			
	  			<!-- <td><?php echo $total_boxes_dispatch_base ?></td> -->
	  			<td><?php echo $total_qty ?></td>
				<td><?php echo $total_customer; ?></td>
	  			<td><?php echo $total_sales_orders; ?></td>
				
	  			<td><?php echo $row['created_on']; ?></td>
	  			<td><?php echo $row['closed_on']; ?></td>
	  			<td><?php if ($row['status'] == 0) { echo "Dispatch Started";
					  } else { echo "Dispatch Closed"; } ?>
				</td>
	  			<td style="width: 8%;">

	  				<a style="font-size:18px; padding: 6px; float: left;" href="dispatch_module.php?disp_id=<?php echo $iddd; ?>"><span data-tooltip title="View" class="cursor"><i  class="fa fa-eye" aria-hidden="true"  style="color:orange; font-size:17px; font-weight:bold;"></i></span></a>
					  <span style="font-size:18px; padding: 6px; float: left;"  ><a href="disp_dispatch_images_all.php?disp_id=<?php echo $iddd; ?>&process_name=loading" target="_blank"><i class="fa fa-file-image-o"></i></a></span>
                    <?php if ($row['status'] == 1) {
					        if ($row['dispatch_type'] == 0 || $row['dispatch_type'] == 1) {	?>
	  				
					<a style="font-size:18px; padding: 6px; float: left;" href="dispatch.php?vehicle_number=<?php echo $row['vehicle_number']; ?>&transporter_name=<?php echo $row['transporter_name']; ?>&dispatch_id=<?php echo $row['id']; ?>&edit=<?php echo 1; ?>&status=<?php echo $row['status']; ?>"><span data-tooltip title="View the Loaded Vehicle data" class="cursor"><i  class="fas fa-shipping-fast" aria-hidden="true" style="color:green;  font-size:17px; font-weight:bold;"></i></span></a>
					
					<?php } else if ($row['dispatch_type'] == 0 || $row['dispatch_type'] == 2) { ?>
					<a style="font-size:18px; padding: 6px; float: left;" href="dispatch_lr_invoice_only.php?vehicle_number=<?php echo $row['vehicle_number']; ?>&transporter_name=<?php echo $row['transporter_name']; ?>&dispatch_id=<?php echo $row['id']; ?>&edit=<?php echo 1; ?>&status=<?php echo $row['status']; ?>"><span data-tooltip title="View the Loaded Vehicle data" class="cursor"><i  class="fas fa-shipping-fast" aria-hidden="true" style="color:green;  font-size:17px; font-weight:bold;"></i></span></a>
					   <?php } 
					   } else { 
					      if ($row['dispatch_type'] == 0 || $row['dispatch_type'] == 1) { ?>
					
					<a style="font-size:18px; padding: 6px; float: left;" href="dispatch.php?vehicle_number=<?php echo $row['vehicle_number']; ?>&transporter_name=<?php echo $row['transporter_name']; ?>&dispatch_id=<?php echo $row['id']; ?>&edit=<?php echo 1; ?>&status=<?php echo $row['status']; ?>"><span data-tooltip title="Load & Edit the LRs and Invoice with boxes" class="cursor"><i  class="fas fa-shipping-fast" aria-hidden="true" style="color:orange;  font-size:17px; font-weight:bold;"></i></span></a>
					
					<?php } if ($row['dispatch_type'] == 0 || $row['dispatch_type'] == 2) { ?>
					
					<a style="font-size:18px; padding: 6px; float: left;" href="dispatch_lr_invoice_only.php?vehicle_number=<?php echo $row['vehicle_number']; ?>&transporter_name=<?php echo $row['transporter_name']; ?>&dispatch_id=<?php echo $row['id']; ?>&edit=<?php echo 1; ?>&status=<?php echo $row['status']; ?>"><span data-tooltip title="Load & Edit the LRs and Invoice Only" class="cursor"><i  class="fas fa-shipping-fast" aria-hidden="true" style="color:blue;  font-size:17px; font-weight:bold;"></i></span></a>
			        <?php } 
					     } ?>
	  			</td>

	  		</tr>

			  <?php
			  $cnt++;
			   }
		      } else {
			?>
			<tr>
				<td><?php echo 'No Record Found'; ?></td>
			</tr>
		  <?php } ?>
  	</tbody>
  </table>
  <div align="center">
	  <?php
	  /* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
	  echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
	  ?>
  </div>
  <?php
}
?>
</div>

