<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM channel_web_store WHERE 1 = 1" . $srcitem . " " . $srcfrom . " " . $role_item . "order by id DESC";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM channel_web_store WHERE 1 = 1" . $role_item . "";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

  if (isset($_POST["page"])) {
	$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
	if (!is_numeric($page_number)) {
	  die('Invalid page number!');
	} //incase of invalid page number
  } else {
	$page_number = 1; //if there's no page number, set it to 1
  }

//Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";
  $srcitem = "";
 if ($_POST['item'] == 'channel_code') {
    $srcitem = " AND channel_code = '" . trim($_POST['colunmData']) . "'";
 } else if ($_POST['item'] == 'channel_name') {
    $srcitem = " AND channel_name = '" . trim($_POST['colunmData']) . "'";
 	
 } else if ($_POST['item'] == 'all') {
    $srcitem = "";
}

  if ($_POST['todt'] != '' && $_POST['fromdt'] != '') {
	$srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
  } else {
	$srcfrom = '';
  }

  ?>
  <p class="details_table">
	  <?php
	  if ($_POST['item'] == '') {
		$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
		if ($is_defaultshowEntries > 20) {
		  $defaultshowEntries = 20;
		} else {
		  $defaultshowEntries = $is_defaultshowEntries;
		}
		?>
		<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
	  <?php } else { ?>
		<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
	  <?php } ?>
  </p>
  <table class="table table-striped table-bordered table-hover dataTable no-footer dtr-inline" id="sample_3" role="grid" aria-describedby="sample_3_info" style="width: 100%;">
  	<thead>
  		<tr>
  			<th> Channel Code </th>
  			<th> Channel Name </th>
  			<th> Description </th>
  			<th> GST No.</th>
  			<th> Office Address</th>
  			<th> Contact No</th>
  			<th> Contact Person Name</th>
  			<th> Contact Email</th>
  			<th> Status</th>
  			<th> Action </th>
  		</tr>
  	</thead>
  	<tbody>

		  <?php
		  //get total number of records from database for pagination
		  $i = 1;
		  $sql_query = "SELECT * FROM channel_web_store WHERE 1 = 1" . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC";

		  $result123 = mysqli_query($mycon, $sql_query);
		  $get_total_rows = mysqli_num_rows($result123);
		  $total_pages = ceil($get_total_rows / $item_per_page);


//get starting position to fetch the records
		  $page_position = (($page_number - 1) * $item_per_page);

		  $sql_query_fetch = "SELECT * FROM channel_web_store WHERE 1 = 1" . $srcitem . " " . $srcfrom . " " . $role_item . " order by id DESC LIMIT $page_position, $item_per_page";

		  $result_fetch = mysqli_query($mycon, $sql_query_fetch);
		  //echo '<br/>' . $sql_query_fetch;
		  //echo '<br/>' . $sql_query;
		  if (mysqli_num_rows($result_fetch) > 0) {
			while ($row = mysqli_fetch_assoc($result_fetch)) {
			  
			  ?>
	  		<tr>

	  			<td> <?php echo $row['channel_code']; ?></td>
	  			<td> <?php echo $row['channel_name']; ?></td>
	  			<td> <?php echo $row['description']; ?></td>
	  			<td> <?php echo $row['gst_no']; ?></td>
	  			<td> <?php echo $row['office_address']; ?></td>
	  			<td> <?php echo $row['contact_no']; ?></td>
	  			<td> <?php echo $row['person_name']; ?></td>
	  			<td> <?php echo $row['contact_email']; ?></td>
	  			<td> <?php if ($row['status'] == 1) {echo "Active";} else{ echo "Inactive"; } ?></td>
	  			<td>
	  				<span data-tooltip title="Edit" class="cursor"><i class="fa fa-pencil-square-o"  onclick="set_all_data_new('<?php echo $row['id']; ?>', '<?php echo $row['channel_code']; ?>','<?php echo $row['channel_name']; ?>','<?php echo $row['description']; ?>','<?php echo $row['gst_no']; ?>','<?php echo $row['office_address']; ?>','<?php echo $row['contact_no']; ?>','<?php echo $row['person_name']; ?>','<?php echo $row['contact_email']; ?>','<?php echo $row['status']; ?>')" aria-hidden="true"  data-toggle="modal" data-target="#myModal"></i>
	  				</span>

	  				<a onclick="return confirm('Are you sure?')" href="channel_web_store.php?cw_id=<?php echo $row['id']; ?>"><span data-tooltip title="Delete" class="cursor"><i class="fa fa-trash" aria-hidden="true"></i></span></a>

	  			</td>
	  		</tr>
			  <?php
			  $cnt++;
			}
		  } else {
			?>
			<tr>
				<td><?php echo 'No Record Found'; ?></td>
			</tr>
  <?php } ?>
  	</tbody>
  </table>
  <div align="center">
  <?php
  /* We call the pagination function here to generate Pagination link for us.
    As you can see I have passed several parameters to the function. */
  echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
  ?>
  </div>
	  <?php
	}
	?>
</div>

