<?php
require_once '../init.php';
include_once 'validate_input_funtion_special_chars_non_numbers.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}

$FileRefNo = $_POST['file_ref_no'];

function formatExcelDate($cellValue)
{
    if (empty($cellValue)) return null;

    if (is_numeric($cellValue)) {
        $unix_date = PHPExcel_Shared_Date::ExcelToPHP($cellValue);
        return date("Y-m-d", $unix_date);
    }
    $date = date_create($cellValue);
    if ($date) {
        return $date->format("Y-m-d");
    }

    return null; // if not a valid date
}

function getVendorDetails($mycon, $vendorCode)
{
    $vendorCode = mysqli_real_escape_string($mycon, $vendorCode);
    $sql = "SELECT * FROM unloading_sender_details WHERE sender_code = '$vendorCode'";
    $result = mysqli_query($mycon, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        return mysqli_fetch_assoc($result);
    }

    return null;
}

function getMaterialDetails($mycon, $ProductCode)
{
    $ProductCode = mysqli_real_escape_string($mycon, $ProductCode);
    $sql = "SELECT * FROM material_master WHERE part_no = '$ProductCode'";
    $result = mysqli_query($mycon, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        return mysqli_fetch_assoc($result);
    }

    return null;
}

function generatePONumber($mycon)
{
    $todayDisplay = date("d/m/Y");
    $todayDate = date("Y-m-d");

    // Find the last PO created today (any vendor)
    $sql = "SELECT po_no FROM po_details 
            WHERE po_date = '$todayDate' 
            ORDER BY id DESC LIMIT 1";
    $result = mysqli_query($mycon, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $parts = explode("/", $row['po_no']);
        $lastSeq = intval(end($parts));
        $nextSeq = str_pad($lastSeq + 1, 3, "0", STR_PAD_LEFT);
    } else {
        $nextSeq = "001"; // first PO of the day
    }

    $PoNumber = "GVL-" . $todayDisplay . "/" . $nextSeq;
    return $PoNumber;
}


function isPOValidDateCorrect($poDate, $poValidDate)
{
    if (empty($poDate) || empty($poValidDate)) return false;
    return strtotime($poValidDate) > strtotime($poDate);
}

if (!empty($_FILES["excel_file"])) {
    $file_array = explode(".", $_FILES["excel_file"]["name"]);
    if ($file_array[1] == "xls" || $file_array[1] == "xlsx") {
        include("PHPExcel/Classes/PHPExcel/IOFactory.php");

        $object = PHPExcel_IOFactory::load($_FILES["excel_file"]["tmp_name"]);
        $worksheet = $object->getSheet(0);

        $highestRow = $worksheet->getHighestRow();
        $total_data = $uploaded_data = $duplicate_data = 0;
        $output = "<label class='text-success'>Data Upload Status</label>
                   <table class='table table-bordered'>
                      <thead>
                          <tr>
                              <th>PO Number</th>
                              <th>PO Title</th>
                              <th>PO Date</th>
                              <th>PO Valid Date</th>
                              <th>Product Code</th>
                              <th>Product Qty</th>
                              <th>Billing Company Name</th>
                              <th>Address</th>
                              <th>Billing Company GST</th>
                              <th>Shipping Company Name</th>
                              <th>Shipping Company Address</th>
                              <th>Shipping Company GST</th>
                              <th>File Ref. No.</th>
                              <th>Upload Status</th>
                          </tr>
                      </thead>
                      <tbody>";

        // Loop through Excel rows starting from row 3
        for ($row = 3; $row <= $highestRow; $row++) {
            $BillingCompanyName  = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(0, $row)->getValue());
            $BillingAddress      = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(1, $row)->getValue());
            $BillingCompanyGST   = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(2, $row)->getValue());

            $ShippingCompanyName = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(3, $row)->getValue());
            $ShippingAddress     = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(4, $row)->getValue());
            $ShippingCompanyGST  = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(5, $row)->getValue());

            $VendorCode = mysqli_real_escape_string($mycon, (string)$worksheet->getCellByColumnAndRow(6, $row)->getValue());
            $PONumber   = mysqli_real_escape_string($mycon, (string)$worksheet->getCellByColumnAndRow(7, $row)->getValue());
            $POTitle    = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(8, $row)->getValue());

            $PODateRaw      = $worksheet->getCellByColumnAndRow(9, $row)->getValue();
            $POValidDateRaw = $worksheet->getCellByColumnAndRow(10, $row)->getValue();

            $PODate      = mysqli_real_escape_string($mycon, formatExcelDate($PODateRaw));
            $POValidDate = mysqli_real_escape_string($mycon, formatExcelDate($POValidDateRaw));

            $ProductCode = mysqli_real_escape_string($mycon, (string)$worksheet->getCellByColumnAndRow(11, $row)->getValue());
            $ProductQty  = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(12, $row)->getValue());
            $UnitPrice   = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(13, $row)->getValue());
            $GSTPercent  = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(14, $row)->getValue());

            $ScopeOfOrder = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(15, $row)->getValue());
            $POCategory   = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(16, $row)->getValue());
            $Taxes        = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(17, $row)->getValue());
            $Freight      = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(18, $row)->getValue());
            $Delivery     = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(19, $row)->getValue());
            $Payment      = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(20, $row)->getValue());
            $Penalty      = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(21, $row)->getValue());

            $TotalAmount = $UnitPrice * $ProductQty;
            $GstAmount   = $TotalAmount * $GSTPercent / 100;
            $GrandTotal  = $TotalAmount + $GstAmount;

            $vendorDetails   = getVendorDetails($mycon, $VendorCode);
            $materialDetails = getMaterialDetails($mycon, $ProductCode);

            $VendorName    = $vendorDetails['sender_name'] ?? '';
            $VendorAddress = ($vendorDetails['sender_address'] ?? '') . ' ' . ($vendorDetails['sender_address1'] ?? '');
            $VendorGst     = $vendorDetails['gst_registration'] ?? '';

            $ProductUOM = $materialDetails['base_unit_of_measure'] ?? '';

            $POCategoryId = ($POCategory == 'Trading A/C PO') ? '1' : '2';

            $row_color = 'red';
            $upload_status = '';

            // validation
            if (empty(trim($VendorCode))) {
                $upload_status = "Invalid Vendor Code";
            } else if (empty($PONumber)) {
                $PONumber = generatePONumber($mycon, $VendorCode);
            } else if (empty(trim($POTitle))) {
                $upload_status = "Invalid PO Title";
            } else if (empty($PODate)) {
                $upload_status = "Invalid PO Date";
            } else if (empty($POValidDate)) {
                $upload_status = "Invalid PO Valid Date";
            } else if (check_special_chars($VendorCode)) {
                $upload_status = "Invalid Vendor Code (Special chars)";
            } else if (check_special_chars($PONumber)) {
                $upload_status = "Invalid PO Number (Special chars)";
            } else if (!$vendorDetails) {
                $upload_status = "Vendor not found";
            } else if (!$materialDetails) {
                $upload_status = "Product not found";
            } else if ($ProductQty <= 0) {
                $upload_status = "Invalid Product Qty";
            } else if ($UnitPrice <= 0) {
                $upload_status = "Invalid Unit Price";
            } else if ($GSTPercent < 0) {
                $upload_status = "Invalid GST %";
            } else if (!isPOValidDateCorrect($PODate, $POValidDate)) {
                $upload_status = "PO Valid Date must be greater than PO Date";
            }

            // insert if valid
            if ($upload_status == '') {
                $check_sql = "SELECT id FROM po_details WHERE po_no = '$PONumber' LIMIT 1";
                $check_res = mysqli_query($mycon, $check_sql);
                if (mysqli_num_rows($check_res) > 0) {
                    $rowData = mysqli_fetch_assoc($check_res);
                    $po_id = $rowData['id'];
                } else {
                    $insert_po = "INSERT INTO po_details (user_id, warehouse_id, billing_company_name, billing_address, billing_gst, shipping_company_name, shipping_address, shipping_gst, sender_name, sender_address1, gst_registration, po_no, po_title, po_date, po_valid_date, scope_of_order, po_category, taxes, freight, delivery, payment, penalty, po_status, uploaded_confirmed, file_ref_no, created_at) VALUES ('$userid','$warehouse_id','$BillingCompanyName', '$BillingAddress', '$BillingCompanyGST','$ShippingCompanyName', '$ShippingAddress', '$ShippingCompanyGST', '$VendorName','$VendorAddress','$VendorGst', '$PONumber', '$POTitle', '$PODate', '$POValidDate', '$ScopeOfOrder', '$POCategoryId','$Taxes', '$Freight', '$Delivery', '$Payment', '$Penalty','7','1','$FileRefNo','$today')";
                    mysqli_query($mycon, $insert_po);
                    $po_id = mysqli_insert_id($mycon);
                }

                $insert_mat = "INSERT INTO po_material (user_id, warehouse_id, po_id, product_code, qty, buying_price, gst_tax_value, total_amount, grand_total, gst_amount,uom,uploaded_confirmed, file_ref_no, created_at) VALUES ('$userid','$warehouse_id','$po_id', '$ProductCode', '$ProductQty', '$UnitPrice', '$GSTPercent', '$TotalAmount', '$GrandTotal','$GstAmount','$ProductUOM', '1','$FileRefNo', '$today')";
                mysqli_query($mycon, $insert_mat);

                $upload_status = "Uploaded Successfully";
                $row_color = 'green';
                $uploaded_data++;
            } else {
                $duplicate_data++;
            }

            $total_data++;

            // add row to table
            $output .= "
            <tr style='color:$row_color'>
                <td>$PONumber</td>
                <td>$POTitle</td>
                <td>$PODate</td>
                <td>$POValidDate</td>
                <td>$ProductCode</td>
                <td>$ProductQty</td>
                <td>$BillingCompanyName</td>
                <td>$BillingAddress</td>
                <td>$BillingCompanyGST</td>
                <td>$ShippingCompanyName</td>
                <td>$ShippingAddress</td>
                <td>$ShippingCompanyGST</td>
                <td>$FileRefNo</td>
                <td>$upload_status</td>
            </tr>";
        }

        $output .= "</tbody></table>";
        $summary = "<b>Total Data:</b> $total_data | <b>Uploaded:</b> $uploaded_data | <b>Errors/Duplicates:</b> $duplicate_data<br/>";
        echo $summary . "<br/>" . $output;
    } else {
        echo '<label class="text-danger">Invalid template file</label>';
    }
} else {
    echo '<label class="text-danger">Please browse the template file.</label>';
}
