<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}
?>
<html>

<head>
    <meta charset="utf-8" />
    <title><?php echo $header_project_name; ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="<?php echo $wmsData['about_wh']; ?>" name="description" />
    <meta content="Vikas Singh" name="author" />
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css" />
    <!-- END GLOBAL MANDATORY STYLES -->
    <link href="../assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/css/components-md.min.css" rel="stylesheet" id="style_components" type="text/css" />
    <link href="../assets/global/css/plugins-md.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/layouts/layout/css/layout.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/layouts/layout/css/themes/darkblue.min.css" rel="stylesheet" type="text/css" id="style_color" />
    <link href="../assets/layouts/layout/css/custom.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="../assets/global/plugins/select2/css/select2-bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link id="page_favicon" href="images/favicon.ico" rel="icon" type="image/x-icon" />

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" />
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f1f1f1;
        }

        .box {
            width: 100%;
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        table.table.table-bordered th {
            background-color: #5cb85cbf;
            color: #fff;
            letter-spacing: 0.4px;
        }

        .table {
            width: 80%;
            max-width: 100%;
            margin-bottom: 20px;
        }

        /* Overlay loader */
        .overlay {
            height: 0%;
            width: 100%;
            position: fixed;
            z-index: 1;
            top: 0;
            left: 0;
            background-color: rgba(0, 0, 0, 0.9);
            overflow-y: hidden;
            transition: 0.5s;
        }

        .overlay-content {
            position: relative;
            top: 25%;
            width: 100%;
            text-align: center;
            margin-top: 30px;
        }

        .overlay a {
            padding: 8px;
            text-decoration: none;
            font-size: 36px;
            color: #818181;
            display: block;
            transition: 0.3s;
        }

        .overlay a:hover,
        .overlay a:focus {
            color: #f1f1f1;
        }

        .overlay .closebtn {
            position: absolute;
            top: 20px;
            right: 45px;
            font-size: 60px;
        }

        /* Card styling for instructions */
        .card {
            border: 1px solid #ccc;
            border-radius: 8px;
            margin-top: 20px;
            background: #fff;
        }

        .card-header {
            color: #fff;
            padding: 10px 15px;
            border-radius: 8px 8px 0 0;
        }

        .card-body {
            padding: 15px;
        }

        .card-body ol {
            line-height: 1.8;
        }
    </style>
    <script>
        function openNav() {
            document.getElementById("myNav").style.height = "100%";
        }

        function closeNav() {
            document.getElementById("myNav").style.height = "0%";
        }
    </script>
</head>

<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed page-md">
    <div class="page-wrapper">
        <?php include 'top_menu.php'; ?>
        <div class="clearfix"> </div>
        <div class="page-container">
            <?php include 'sidebar.php'; ?>
            <div class="page-content-wrapper">
                <div class="page-content">
                    <div class="row">

                        <div id="myNav" class="overlay">
                            <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
                            <div class="overlay-content">
                                <h1 style="color:white;">Uploading... Please Wait.</h1>
                            </div>
                        </div>

                        <div class="container box">
                            <h3 align="center">Import Bulk PO Data</h3>


                            <!-- Instructions Card -->
                            <div class="card">
                                <div class="card-header">
                                    <a onclick="history.go(-1)" class="btn btn-success" style="float:right;">Back</a>
                                    <a href="uploaded_po_management_data.php" class="btn btn-success" style="float:right; margin-right: 10px">Go to Uploaded Data Page</a>

                                    <h4 style="margin:0;">Instructions for Sample Excel Template</h4>
                                </div>
                                <div class="card-body">
                                    <ol>
                                        <li>Your Excel Template data should be in the format below. The first line of your excel template file should be the column headers as in the table example. Also make sure that your file is UTF-8 to avoid unnecessary encoding problems.</li>
                                        <li>If the column you are trying to import is a date, make sure it is formatted in <b>Y-m-d</b> (e.g., 2021-01-09).</li>
                                        <li>Valid File Format: <b>.xlsx</b></li>
                                        <li>Special characters restriction: single quote ( ' ) and less than ( &lt; )</li>
                                        <li>Compulsory Field's Color and Optional Field's Color are mentioned in Excel Template.</li>
                                        <li>Special Field's Values and their meanings are also explained in the template.</li>
                                    </ol>

                                    <form action="#" method="post" style="margin-top:20px;">
                                        <div>
                                            <label for="location">File Reference Number: </label>
                                            <input type="text" name="fileref" style="border:none;" value="<?php echo time(); ?>" readonly />
                                            <br /><span>(*File Reference Number for future uses)</span>
                                        </div>
                                        <br />
                                        <div class="buttons">
                                            <a href="templates/bulk_po_upload_template_sheet.xlsx" class="btn btn-success" download="Bulk PO Upload Template">Download Uploading Bulk PO Data Template File</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- End Instructions Card -->

                            <br />

                            <form method="post" id="export_excel">
                                <div>
                                    <label>Select Uploading Manual Box Data Excel File (.xlsx file format)</label>
                                    <input type="hidden" id="file_ref_no" name="file_ref_no" value="<?php echo time(); ?>">
                                    <input type="file" name="excel_file" id="excel_file" required accept=".xlsx" />
                                </div>
                            </form>
                            <br />
                            <div id="result"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</body>

</html>

<script>
    $(document).ready(function() {
        $('#excel_file').change(function() {
            $('#export_excel').submit();
            openNav();
        });
        $('#export_excel').on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                url: "import_bulk_po_data_template.php",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#result').html(data);
                    $('#excel_file').val('');
                    closeNav();
                }
            });
        });
    });
</script>