<?php
require_once '../init.php';

if (not_logged_in() === true) {
    header('Location: ../index.php');
    exit();
}

$challan_id = isset($_POST['id']) ? $_POST['id'] : '';

$response = [
    'challan_qty' => 0,
    'po_no' => '',
    'supplier_name' => '',
    'table_html' => ''
];

if ($challan_id != '') {

    // 1. Get challan summary
    $sql_qty = "SELECT SUM(qty) AS TotalQty, po_no, vendor_code FROM vendor_challan_tbl 
                WHERE challan_no = '$challan_id' GROUP BY challan_no";

    $result_qty = mysqli_query($mycon, $sql_qty);

    if ($row = mysqli_fetch_assoc($result_qty)) {
        $response['challan_qty']   = $row['TotalQty'];
        $response['po_no']         = $row['po_no'];
        $response['supplier_name'] = $row['vendor_code'];
    }

    // 2. Fetch remark options
    $remark_options = '<option value="">Select</option>';
    $sql_query_remark = "SELECT remark_title FROM remark_master";
    $result_re = mysqli_query($mycon, $sql_query_remark);
    if ($result_re && mysqli_num_rows($result_re) > 0) {
        while ($rowre = mysqli_fetch_assoc($result_re)) {
            $remark_title   = htmlspecialchars($rowre['remark_title']);
            $remark_options .= '<option value="' . $remark_title . '">' . $remark_title . '</option>';
        }
    }

    // 3. Fetch product data with remaining qty
    $ProductDetail = " SELECT  vc.product_code, vc.qty AS challan_qty,IFNULL(SUM(ue.grn_rev_qty), 0) AS used_qty FROM vendor_challan_tbl vc LEFT JOIN upload_excel ue ON vc.challan_no = ue.invoice_no AND vc.product_code = ue.product_code WHERE vc.challan_no = '$challan_id'  GROUP BY vc.product_code, vc.qty ";
    
    $ProductResult = mysqli_query($mycon, $ProductDetail);

    // 4. Build table HTML
    $table_html = '<div class="col-md-12">
        <div class="text-right mb-3" style="display:none;" id="submitAllContainer">
            <button type="button" id="submitAllBtn" class="btn btn-primary">Submit All</button>
        </div>
        <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover">
            <thead style="background:#1fac8b; color:white;">
                <tr>
                    <th><input type="checkbox" id="checkAll"></th>
                    <th>Product Code</th>
                    <th>Product Challan Qty</th>
                    <th>Gross Product Qty</th>
                    <th>No of Boxes/Crates</th>
                    <th>Discrepancy Product Qty</th>
                    <th>Remark of Discrepancy Product</th>
                    <th>Discrepancy No of Boxes/Crates</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>';

    $hasRows = false;

    if ($ProductResult && mysqli_num_rows($ProductResult) > 0) {
        while ($ProductRows = mysqli_fetch_assoc($ProductResult)) {
            $product_code = htmlspecialchars($ProductRows['product_code']);
            $challan_qty = floatval($ProductRows['challan_qty']);
            $used_qty = floatval($ProductRows['used_qty']);
            $remaining_qty = $challan_qty - $used_qty;

            // ❗ Skip if fully used
            if ($remaining_qty <= 0) {
                continue;
            }

            $hasRows = true;

            $table_html .= '<tr>
                <td><input type="checkbox" class="row-check"></td>
                <td>' . $product_code . '</td>
                <td>' . number_format($remaining_qty, 2) . '</td>
                <td><input type="text" class="form-control grn_rev_qty" style="width:150px;"></td>
                <td><input type="text" class="form-control no_of_boxes" style="width:150px;"></td>
                <td><input type="text" class="form-control issue"></td>
                <td>
                    <select class="form-control qty_issue_remark_po" style="width:100%; padding:5px;">
                        ' . $remark_options . '
                    </select>
                </td>
                <td><input type="text" class="form-control no_of_boxes_issue"></td>
                <td><textarea class="form-control filter_remark" style="width:180px;"></textarea></td>
                <td><button type="button" class="btn btn-success btn-sm submit-btn">ADD</button></td>
            </tr>';
        }
    }

    // If no valid rows found
    if (!$hasRows) {
        $table_html .= '<tr><td colspan="10" class="text-center">No products with remaining quantity.</td></tr>';
    }

    $table_html .= '</tbody></table></div></div>';

    $response['table_html'] = $table_html;
}

// Return JSON
header('Content-Type: application/json');
echo json_encode($response);
exit();
