<?php
require_once '../init.php';

$id = $_GET['crate_id'];

$sql = "SELECT * FROM dispatch_crate_mapping_tbl WHERE crate_id = '$id'";
// echo $sql;
$result = $mycon->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    $crate_id = $row['crate_id'] ?? "N/A";
    $order_id = $row['order_id'] ?? "N/A";
    $challan_no = $row['challan_no'] ?? "N/A";
    $part_no = $row['part_no'] ?? "N/A";
    $part_desc = $row['part_desc'] ?? "N/A";
    $batch_code = $row['batch_code'] ?? "N/A";
    $order_location = $row['order_location'] ?? "N/A";
    $crate_weight = $row['crate_weight'] ?? "N/A";
    $crate_box_weight = $row['crate_box_weight'] ?? "N/A";
    $created_at = date("d-m-Y H:i") ?? "N/A";
    
    $FinalWeight = $crate_weight - $crate_box_weight;

    $update_sql = "UPDATE dispatch_crate_mapping_tbl 
                   SET sticker_print_count = sticker_print_count + 1 
                   WHERE crate_id = '$id'";
                // echo $update_sql;
    $mycon->query($update_sql);


} else {
    $crate_id = $order_id = $challan_no = $part_no = $part_desc = $order_location = $crate_weight = $created_at = "N/A";
    $sticker_print_count = 0;
}

$qr_text   = "Crate: $crate_id / Order: $order_id / challan_no: $challan_no / part_no: $part_no";
$qr_encoded = urlencode($qr_text);
$qr_url     = "https://api.qrserver.com/v1/create-qr-code/?data=$qr_encoded&size=200x200";
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Generate Shipment</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background: #f5f5f5;
            font-family: "Segoe UI", Arial, sans-serif;
        }

        .label {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            width: 76.2mm;
            height: 50.8mm;
            border: 1.5px solid #000;
            border-radius: 5px;
            padding: 4mm;
            background-color: #fff;
            box-sizing: border-box;
            margin: 15px auto;
            box-shadow: 0 0 3px rgba(0, 0, 0, 0.2);
        }

        .qr-section {
            flex: 0 0 25mm;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .qr-section img {
            width: 24mm;
            height: 24mm;
        }

        .text-section {
            flex: 1;
            padding-left: 5mm;
            font-size: 9pt;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .text-section p {
            margin: 0;
            line-height: 1.2;
            font-size: 8.5pt;
        }

        .text-section p span {
            font-weight: bold;
            color: #000;
        }

        @media print {
            body {
                background: #fff;
                margin: 0;
            }

            .label {
                margin: 0;
                box-shadow: none;
            }
        }
    </style>
</head>

<body>
    <div class="label">
        <div class="qr-section">
            <img src="<?= $qr_url ?>" alt="QR Code">
        </div>
        <div class="text-section">
            <p><span>Crate:</span> <?= htmlspecialchars($crate_id) ?></p>
            <p><span>Order:</span> <?= htmlspecialchars($order_id) ?></p>
            <p><span>Challan:</span> <?= htmlspecialchars($challan_no) ?></p>
            <p><span>Part:</span> <?= htmlspecialchars($part_no) ?></p>
            <p><span>Part Desc:</span> <?= htmlspecialchars($part_desc) ?></p>
            <p><span>Batch:</span> <?= htmlspecialchars($batch_code) ?></p>
            <p><span>Loc:</span> <?= htmlspecialchars($order_location) ?></p>
            <p><span>Weight:</span> <?= htmlspecialchars($FinalWeight) ?></p>
            <p><span>Date:</span> <?= htmlspecialchars($created_at) ?></p>
        </div>
    </div>

    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>

</html>