<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
    exit;
}

$today = date('Y-m-d H:i:s');

function GetCustomerData($CustomerCode, $mycon)
{
    $CustomerCode = mysqli_real_escape_string($mycon, $CustomerCode);
    $CustomerQ = "SELECT * FROM customer_details WHERE customer_code = '$CustomerCode'";
    $ResultCust = mysqli_query($mycon, $CustomerQ);
    return ($ResultCust && mysqli_num_rows($ResultCust) > 0) ? mysqli_fetch_assoc($ResultCust) : [];
}

function GetProductMaterialData($ProductCode, $mycon)
{
    $ProductCode = mysqli_real_escape_string($mycon, $ProductCode);
    $ProductQ = "SELECT * FROM material_master WHERE part_no = '$ProductCode'";
    $ResultP = mysqli_query($mycon, $ProductQ);
    return ($ResultP && mysqli_num_rows($ResultP) > 0) ? mysqli_fetch_assoc($ResultP) : [];
}

function GetAvailableQty($ProductCode, $mycon)
{
    $ProductCode = mysqli_real_escape_string($mycon, $ProductCode);
    $AvailableQtyQ = "SELECT SUM(quantity) AS AvailableQty FROM temp_split_quantity_putway WHERE product_code = '$ProductCode'";
    $ResultQty = mysqli_query($mycon, $AvailableQtyQ);
    $row = ($ResultQty && mysqli_num_rows($ResultQty) > 0)? mysqli_fetch_assoc($ResultQty) : ['AvailableQty' => 0];
    return $row['AvailableQty'] ?? 0;
}

function get_binning_type($pro_code,$mycon,$total_qty)
   {
	   $new_id=0;
	   $sql_query="SELECT id,packing_quantity FROM packing_data where product_code='$pro_code' and putway_status=1 order by packing_quantity asc ";
        $result = mysqli_query($mycon, $sql_query);
         if (mysqli_num_rows($result) > 0) {
			 $count1=0;
          while ($row = mysqli_fetch_assoc($result)) 
		  {  
			   $packing_quantity=$row['packing_quantity'];
			   $id=$row['id'];
			  // echo "<br/>";
			   $f_total= get_packedval($pro_code,$mycon,$id);
		
			
			  $packing_quantity=$packing_quantity - $f_total;
			
			   if($packing_quantity>=$total_qty)
			   {
				   $new_id=$id;
				   break;
				   
			   }
			   else
			   {
				   continue;
			   }
		  }
		  
		}
		return $new_id;
   }


// ---------------- MAIN LOGIC ----------------
$CustomerId = mysqli_real_escape_string($mycon, $_POST['CustomerCode']);
$fileRefNo  = mysqli_real_escape_string($mycon, $_POST['fileRefNo'] ?? '');
$GetCustomerOrders = "SELECT * FROM bulk_order_data_tbl WHERE customer_code = '$CustomerId'";
$ResultOrder = mysqli_query($mycon, $GetCustomerOrders);

if (!$ResultOrder || mysqli_num_rows($ResultOrder) == 0) {
    echo "<span style='color:red;'>No products found for this customer.</span>";
    exit;
}

$customerDetails = GetCustomerData($CustomerId, $mycon);
$today = date('Y-m-d');
$insertedOrders = 0;
$errorCount = 0;

// take first record's crate_order_date for base date
$rowFirst = mysqli_fetch_assoc($ResultOrder);
$crate_order_date = $rowFirst['crate_order_date'];
mysqli_data_seek($ResultOrder, 0); // reset pointer

// Start date = crate_order_date + 2 days
$start_date = date('Y-m-d', strtotime($crate_order_date . ' +2 day'));

// 7 consecutive days
$day_columns = ['thursday','friday','saturday','sunday','monday','tuesday','wednesday'];

// Create 7 orders
for ($i = 0; $i < 7; $i++) {
    $order_date = date('Y-m-d', strtotime($start_date . " +$i day"));
    $OrderRefNumber = time() . rand(100, 999);
    $picking_id = 'PL'.''.time();
    
    $CityState = $customerDetails['city'].'/'.$customerDetails['state'];
    
    $id_packing=get_binning_type($p_code,$mycon,$qty);

    // Insert order_management row
    $order_sql = "INSERT INTO order_management (user_id, warehouse_id, order_type, ref_number, order_menthod,channel, order_date, customer_id, customer_code, created_on, s_contact_person_name, s_address, s_city_state, s_location, s_area, s_phone, email, shipName, ShipAddress, ShipPincode, submit_status, submitted_on, is_generate_picklist, order_status, order_priority, order_booking_type,picking_id) VALUES ('$userid', '$warehouse_id', '0', '$OrderRefNumber', 'By E-mail','Weekly Order', '$order_date', '" . $customerDetails['customer_id'] . "', '" . $CustomerId . "', '$today', '" . $customerDetails['contact_prsn_name'] . "', '" . $customerDetails['address1'] . "', '" . $CityState . "', '" . $rowFirst['location'] . "', '" . $rowFirst['kitchen_area'] . "','" . $customerDetails['phone_number'] . "', '" . $customerDetails['email'] . "', '" . $customerDetails['company_name'] . "', '" . $customerDetails['shipping_address'] . "', '" . $customerDetails['pincode'] . "', '1', '$today', '0', '2', 'Normal', 'Sales Delivery Order','$picking_id')";

    if (mysqli_query($mycon, $order_sql)) {
        $order_id = mysqli_insert_id($mycon);
        $insertedOrders++;

        // now insert all products for this order date
        mysqli_data_seek($ResultOrder, 0); // rewind to start for all products again
        while ($prodRow = mysqli_fetch_assoc($ResultOrder)) {
            $ProductDetails = GetProductMaterialData($prodRow['code'], $mycon);
            $AvailableQty = GetAvailableQty($prodRow['code'], $mycon);
            $day_col = $day_columns[$i];
            $qty = (float)$prodRow[$day_col];

            $OrderProducts = "INSERT INTO order_material (user_id, warehouse_id, ref_number, product_code, product_desc, product_color, product_packing_configuration, avaliable_qty, unit_price, qty, created_on, order_id, customer_code,submit_status,id_packing) VALUES ('$userid', '$warehouse_id', '$OrderRefNumber', '" . $prodRow['code'] . "', '" . $ProductDetails['desc'] . "', '" . $ProductDetails['color'] . "', '" . $ProductDetails['packing_configuration'] . "', '$AvailableQty', '" . $ProductDetails['price'] . "', '$qty', '$today', '$order_id',  '$CustomerId','1','$id_packing')";

            if (!mysqli_query($mycon, $OrderProducts)) {
                $errorCount++;
            }
        }

    } else {
        $errorCount++;
    }

    // reset result pointer for next loop
    mysqli_data_seek($ResultOrder, 0);
}

if ($insertedOrders == 7 && $errorCount == 0) {
    $updateQuery = "UPDATE bulk_order_data_tbl SET is_generate_order = 1, order_generated_on = '$today' WHERE customer_code = '$CustomerId'  AND file_ref_num = '$fileRefNo'";
    if(mysqli_query($mycon, $updateQuery)){
    echo "✅ Successfully created 7 day-wise orders (Thu–Wed) with product data inserted for each order.";
    } else {
        echo "Order Generated but Update Order Not Performed. Please Contact To IT Team";
    }
} elseif ($insertedOrders == 7) {
    echo "<span style='color:orange;'>⚠️ All 7 orders created but some product entries had issues ($errorCount errors).</span>";
} else {
    echo "<span style='color:red;'>❌ Failed to insert all 7 orders properly.</span>";
}
?>
